/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 15 juin 2005 
 * @author Nicolas Garandeau (LIP6)
 */
package org.eclipse.mddi.modelbus.adapter.test.asynchronous;

import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;


public class SortModelingServiceImpl implements GenericProvider {
    
    EcoreFactory fac = EcorePackageImpl.init().getEcoreFactory(); 
   
    
    public static final String sort_serviceName = "sort";
    

    /* (non-Javadoc)
     * @see org.eclipse.mddi.modelbus.adapter.tool.ServiceInvocation#execute(java.lang.String, java.lang.Object[])
     */
    public Object[] execute(String serviceName, Object[] parameterValues)
            throws SessionNeeded, ModelingServiceError {
      
    	
    	System.out.println("\n\n\n--> execute method from SortModelingServiceImpl");
    	
        if(serviceName.equalsIgnoreCase(sort_serviceName)) {
        	
        	
         Object[] res = increaseFirstParameter((Object[])parameterValues);	
         System.out.println("\n--> end of execute method from SortModelingServiceImpl \n\n\n");
          return res;
        } 
        
        System.out.println("\n--> FAILURE : end of execute method from SortModelingServiceImpl (service \""+serviceName+"\" unknown)\n\n\n");
        throw new ModelingServiceError("NoImplementation", null);
    }
    
    
    Object[] increaseFirstParameter(Object[] parameterValues) throws ModelingServiceError {

    	String stringParam1 = (String) parameterValues[0];
    	int value = Integer.parseInt(stringParam1);
    	value++;
    	try {
			Thread.sleep(5000);
		} catch (InterruptedException e) {
			
			e.printStackTrace();
		}
    	Object[] res = new Object[1];
        res[0] = ""+value;
             
        return res;        
    }
    
    
    
    



    
    public static void main(String[] args) throws SessionNeeded, ModelingServiceError {
		SortModelingServiceImpl smsi = new SortModelingServiceImpl();
		
		Object[] res = smsi.execute(sort_serviceName,null);
		
		System.out.println("Result after unit test : "+res[0]);
	

    }

}
