/*
 * $RCSfile: CustomDeployTool.java,v $
 * $Date: 2006/03/13 16:18:07 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * CustomDeployTool.java  
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:18:07 $
 */
package org.eclipse.mddi.modelbus.adapter.test.deploy;

import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;

/*
 * CustomDeployTool
 * 
 */

public class CustomDeployTool implements GenericProvider {

    public static Logger logger = Logger.getLogger(CustomDeployTool.class);
    Collection model = new Vector();
    


    /**
     * 
     */
    public CustomDeployTool() {
        super();
    }

 
    public static boolean isStarted = false;

    public static void main(String args[]) {

        if (isStarted)
            return;

        String registry_loc;
        if (args.length > 0) {
            registry_loc = args[0];
        } else {
            registry_loc = "http://localhost:8082/modelbus/modelwareRegistry";
        }

        String desc_file;
        if (args.length > 1) {
            desc_file = args[1];
        } else {
            desc_file = "./src/org/eclipse/mddi/modelbus/adapter/test/sample/sample.description";
        }

        try {

            Properties p = new Properties();
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);
            p.put(AdapterStub.PROP_TOOL_DESC_FILE, desc_file);
            p.put(AdapterStub.MODELBUS_PORT, "9999");

            AdapterStub adapter = new AdapterStubImpl(p);

            GenericProvider provider = new CustomDeployTool();

            adapter.getToolStub().setProvider(provider);
            
            adapter.deploy();
            logger.info("Tool is deployed...");
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }

    }

    /* (non-Javadoc)
     * @see org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider#execute(java.lang.String, java.lang.Object[])
     */
    public Object[] execute(String serviceName, Object[] parameterValues) throws SessionNeeded, ModelingServiceError {
        // TODO Auto-generated method stub
        return new Object[]{model};
    }
}
