/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 21 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.plugin;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.test.plugin.ui.ConsoleView;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 *  Sets the URL for a remote Registry.
 *  See the method run() in this class.
 * 
 * @author Andrey Sadovykh (LIP6)
 *
 */
public class SetRegistryAction implements IWorkbenchWindowActionDelegate {
    
	private IWorkbenchWindow window;
	
	
	private static boolean isStarted = false;
    
    private static final String INIT_URL = BasicRegistry.getUrl();  
    
    private static String registryURL=null;
    
    private static InputDialog dialog;
    
     	
	/**
	 * The constructor.
	 */
	public SetRegistryAction() {
        
        LoggerConfigurator.configure();

        dialog = new InputDialog (null, "Registry URL settings", "In case you are using Registry in a different URL, please specify its URL hereafter. Note, the settings are taken into account only before Provider/Consumer is deployed ", INIT_URL,null);
	}

	/**
	 * Runs Registry.
	 */
	public void run(IAction action) {
        try {
            dialog.open();
            setRegistryURL(dialog.getValue());
          
            //setRegistryURL("http://localhost:8082/Registry");
            if (getRegistryURL()!=null){
                ConsoleView.displayMessage("The registry location was set to:"+getRegistryURL()+"\n");
            }else{
                ConsoleView.displayMessage("Using default local host Registry.\n");
            }
        } catch (Exception e) {
            ConsoleView.displayMessage(e);
        }
	}

	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

    /**
     * @return Returns the registryURL.
     */
    public static String getRegistryURL() {
        return registryURL;
    }

    /**
     * @param registryURL The registryURL to set.
     */
    public static void setRegistryURL(String registryURL) {
        SetRegistryAction.registryURL = registryURL;
    }
}
