/*
 * $RCSfile: ProfileSupportedConsumerTool.java,v $
 * $Date: 2006/04/12 15:33:04 $
 * $Revision: 1.3 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ProfileSupportedConsumerTool.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.3 $ $Date: 2006/04/12 15:33:04 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.test.profile;

import java.util.Collection;
import java.util.Properties;

import org.eclipse.emf.common.util.URI;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Profile;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.Uml2ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;


/**
 * This test checks that a UML model can be transmitted as a service parameter.
 * The profile must be registerred at the service side prior to service invocation.
 * 
 * The profile will NOT be transmitted with the model but the links between the model and the profile
 * can be established upon model reception.
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 *
 *
 */
public class ProfileSupportedConsumerTool {
    
    public static String REG = BasicRegistry.getUrl();
    
    static String umlResourceURI = "jar:file:/D:/eclipse3.1.1/plugins/org.eclipse.uml2.resources_1.1.0.jar!/";
    
    static final int PROFILE_FILE = 0;
    static final int MODEL_FILE = 1;
    static final int PROFILE_URI = 2;  
    
    // profile, profiled model, the URI from the profiled model to the profile definition
    public static String[] case1 = {
             "src/org/eclipse/mddi/modelbus/adapter/test/profile/Ecore.profile.uml2"  //profile location    
            ,"src/org/eclipse/mddi/modelbus/adapter/test/profile/ExtendedPO2_Ecore.uml2" //model location
            ,"Ecore.profile.uml2"  //the URI that links the model file with the profile file.
    };
    
    public static String[] case2 = {
        "src/org/eclipse/mddi/modelbus/adapter/test/profile/MyProfile.profile.uml2"  // profile location
        ,"src/org/eclipse/mddi/modelbus/adapter/test/profile/MySystem.uml2" // model location
        ,"MyProfile.profile.uml2"     //the URI that links the model file with the profile file.
    };
  
    public static String[] testcase = case2;    
        
    public static void main(String[] args) throws Exception {
        

       
        if(args.length > 1 ) {
            REG = args[0];
            umlResourceURI = args[1];
        }
        
        Uml2ModelUtil.init(URI.createURI(umlResourceURI));         
        
        Properties p;
        p = new Properties();
        p.put(AdapterStub.PROP_REGISTRY_LOCATION, REG);
        AdapterStub stub = new AdapterStubImpl(p);       
        GenericConsumer si = stub.getGenericConsumer();
        
        // Load and register your profile so that it can be managed by ModelBus
        // If the profile is already loaded, use Uml2ModelUtil.registerProfile(Profile prof) instead        
        Profile prof = Uml2ModelUtil.registerProfile(
                URI.createURI( testcase[PROFILE_FILE] ));

 
        // If you model has URI1 referencing the profile.
        // Then you need to set Alias : URI1 -> your profile
        // so that ModelBus avoid reloading the same profile twice.
        // Ex.  Uml2ModelUtil.setAliasToProfile( URI.createFileURI("src/profile/MyProfile.profile.uml2"), prof);
        Uml2ModelUtil.setAliasURIToProfile( URI.createURI(testcase[PROFILE_URI]), prof);       
        
        // load your profiled model. 
        //   - possible to use other technique than Xmi2EmfConversion.loadFromFile()
        //   - The essential is that the linked profile from model 
        //     and the registerred profile must be the same object.
        Model m = (Model) Xmi2EmfConversion.loadFromFile(testcase[MODEL_FILE]).get(0);

        // test link between the model and the profile
        Uml2ModelUtil.hasLink(m, prof);
        System.out.println("......... invoking service");        
        // invoke service
        Object[] inputs = { m.eResource().getContents() };
        Object[] outputs = si.consume("inoutModelService", inputs);
        
        System.out.println("......... result");
        Model result = (Model) ((Collection) outputs[0]).iterator().next();
        // show tag values in the model
        ProfileSupportedTool.examineProfiledModel(result);

        
    }
}
