/*
 * $RCSfile: NotificationProducerTest.java,v $
 * $Date: 2006/03/13 16:18:07 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * NotificationProducerTest.java 
 * 
 * @author Prawee Sriplakich (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:18:07 $
 */
package org.eclipse.mddi.modelbus.adapter.test.sample;

import java.util.Properties;


import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.notification.Notification;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationPublisher;

/**
 * Starts a tool that produces notifications
 * 
 * 
 * @author Prawee Sriplakich (LIP6)
 *
 *
 */
public class NotificationProducerTest {

    public static void main(String[] args) throws DeploymentException, NotifServiceNotAvailableException {
        
        Properties p = new Properties();
        p.put(AdapterStub.PROP_NOTIF_LOCATION, "http://localhost:8080/axis/services/NotificationBroker");
                
        AdapterStub adapter = new AdapterStubImpl(p);
        
        NotificationPublisher pub = adapter.getNotificationPublisher();
        
        Notification notif = new Notification("ModelChangeNotification", "MODEL1");

        
        pub.publish(notif);
    }
}
