/*
 * $RCSfile: SerializerModelingService.java,v $
 * $Date: 2006/03/13 16:18:07 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * SerializerModelingService.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:18:07 $
 */
package org.eclipse.mddi.modelbus.adapter.test.serializer;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;

/**
 * 
 * SerializerModelingService impleaments a dummy tool, that construct a model using a
 * className provided. It uses models in String representation.
 *
 */
public class SerializerModelingService implements GenericProvider {

    Logger logger = Logger.getLogger(SerializerModelingService.class);

    public Object[] execute(String serviceName, Object[] parameterValues)
            throws SessionNeeded, ModelingServiceError {
        String className = (String) parameterValues[0];
        String model = (String) parameterValues[1];
        
        logger.info("Model recieved:"+model);
        
        model  = "<xmi:XMI xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\">"
        +"<ecore:EClass name=\""+className+"\"/>"
        +"</xmi:XMI>";
        
        return new Object[]{model};
    }
 
}
