/*
 * $RCSfile: SampleToolDeployServlet.java,v $
 * $Date: 2006/03/13 16:18:07 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * SampleToolDeployServlet.java 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:18:07 $
 */
package org.eclipse.mddi.modelbus.adapter.test.tomcat;
import java.util.Properties;

import javax.servlet.ServletConfig;

import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ModelBusServlet;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.test.sample.SampleModelingServiceImpl;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;

public class SampleToolDeployServlet extends ModelBusServlet {

    /**
     * 
     */
    private static final long serialVersionUID = 47931368476907916L;

    public void init(ServletConfig config) {
        setDefaultPort(8080);
        setDefaultContext("modelbus_tomcat");
        registerServer();

        // Deploying all Provider tools as usual
        // put registry location here
        String registry_loc = BasicRegistry.getUrl();
        // put right description file here
        String desc_file = config.getServletContext().getRealPath("WEB-INF/classes/sample.description");

        //load properties
        Properties p = new Properties();
        p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);
        p.put(AdapterStub.PROP_TOOL_DESC_FILE, desc_file);

        //deploy tool as usual
        AdapterStub adapter;
        try {
            adapter = new AdapterStubImpl(p);
            GenericProvider provider = new SampleModelingServiceImpl(); 
            adapter.getToolStub().setProvider(provider);
            adapter.deploy();
       } catch (DeploymentException e) {
            e.printStackTrace();
        }


    }
}
