/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.MergeHelper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;

public class DeltaApplication {
    static Logger logger = Logger.getLogger((String)"DeltaApplication");
    MBXmiResource resource;
    public Set deletedNodes = new HashSet();
    Map orderPropertyValue = new Hashtable();

    public DeltaApplication(MBXmiResource model) {
        this.resource = model;
        TreeIterator it = this.resource.getAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            Iterator it2 = o.eClass().getEAllReferences().iterator();
            while (it2.hasNext()) {
                EReference r = (EReference)it2.next();
                if (!r.isOrdered() || !r.isMany()) continue;
                String id = this.resource.getURIFragment(o);
                List l = (List)o.eGet((EStructuralFeature)r);
                List ids = MergeHelper.getIDList(l);
                Vector<String> key = new Vector<String>();
                key.add(id);
                key.add(r.getName());
                this.orderPropertyValue.put(key, ids);
            }
        }
    }

    public void apply(Delta d) {
        NodeLevelSubDelta nl;
        Iterator it = d.getContent().iterator();
        while (it.hasNext()) {
            nl = (NodeLevelSubDelta)it.next();
            if (nl instanceof Create) {
                this.applyCreate((Create)nl);
            }
            if (!(nl instanceof Delete)) continue;
            this.deletedNodes.add(this.resource.getEObject(nl.getId()));
        }
        it = d.getContent().iterator();
        while (it.hasNext()) {
            nl = (NodeLevelSubDelta)it.next();
            this.applyModify(nl);
        }
        this.applyDelete();
    }

    public void applyCreate(Create c) {
        EObject o = EcoreUtil.create((EClass)c.getType());
        this.resource.getIdTable().assignId(c.getId(), o);
        this.resource.getContents().add((Object)o);
    }

    public void applyDelete() {
        TreeIterator it = this.resource.getAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            Iterator it2 = o.eClass().getEAllReferences().iterator();
            while (it2.hasNext()) {
                EReference r = (EReference)it2.next();
                if (r.isMany()) {
                    List l = (List)o.eGet((EStructuralFeature)r);
                    l.removeAll(this.deletedNodes);
                    continue;
                }
                EObject v = (EObject)o.eGet((EStructuralFeature)r);
                if (v == null || !this.deletedNodes.contains(v)) continue;
                o.eSet((EStructuralFeature)r, null);
            }
        }
    }

    public void applyModify(NodeLevelSubDelta mod) {
        EObject o = this.resource.getEObject(mod.getId());
        if (o == null) {
            logger.debug((Object)("null object " + mod.getId()));
            return;
        }
        Iterator it2 = mod.getContent().iterator();
        while (it2.hasNext()) {
            ModifyProp modProp = (ModifyProp)it2.next();
            if (modProp instanceof ModifyPrimitive) {
                this.applyModifyPrimitive(o, (ModifyPrimitive)modProp);
                continue;
            }
            if (!(modProp instanceof ModifyLink)) continue;
            ModifyLink ml = (ModifyLink)modProp;
            if (ml.getRemove() != null) {
                this.applyRemoveLink(o, (EReference)ml.getProperty(), ml.getRemove());
            }
            Iterator it3 = ml.getInsert().iterator();
            while (it3.hasNext()) {
                InsertLink il = (InsertLink)it3.next();
                this.applyInsertLink(o, (EReference)ml.getProperty(), il);
            }
        }
    }

    public void applyModifyPrimitive(EObject o, ModifyPrimitive mp) {
        EAttribute a = (EAttribute)mp.getProperty();
        Object value = MergeHelper.deserializeValue(a, mp.getValue());
        if (mp.getProperty().isMany()) {
            List l = (List)o.eGet((EStructuralFeature)a);
            l.clear();
            l.addAll((List)value);
        } else {
            o.eSet(mp.getProperty(), value);
        }
    }

    public void applyInsertLink(EObject o, EReference r, InsertLink il) {
        if (!r.isMany()) {
            String id = (String)il.getRef().get(0);
            EObject value = this.resource.getEObject(id);
            o.eSet((EStructuralFeature)r, (Object)value);
            return;
        }
        List insertedRefs = MergeHelper.getEObjectList((Resource)this.resource, (List)il.getRef());
        List currentRefList = (List)o.eGet((EStructuralFeature)r);
        if (!r.isOrdered()) {
            currentRefList.addAll(insertedRefs);
            return;
        }
        currentRefList.removeAll(insertedRefs);
        if (il.getPosAfter() == null || il.getPosAfter().equals("")) {
            currentRefList.removeAll(insertedRefs);
            currentRefList.addAll(0, insertedRefs);
        } else {
            String id = this.resource.getURIFragment(o);
            Vector<String> key = new Vector<String>();
            key.add(id);
            key.add(r.getName());
            List oldIdList = (List)this.orderPropertyValue.get(key);
            if (oldIdList == null) {
                logger.error((Object)("Old property value not found " + id + " " + r.getName()));
                return;
            }
            List currentIdList = MergeHelper.getIDList(currentRefList);
            String posAfter = il.getPosAfter();
            int previousIndexOfPosId = oldIdList.indexOf(posAfter) - 1;
            while (!currentIdList.contains(posAfter) && previousIndexOfPosId >= 0) {
                posAfter = (String)oldIdList.get(previousIndexOfPosId);
                --previousIndexOfPosId;
            }
            int insertIndex = currentIdList.indexOf(posAfter) + 1;
            currentRefList.addAll(insertIndex, insertedRefs);
        }
    }

    public void applyRemoveLink(EObject o, EReference r, RemoveLink rl) {
        if (!r.isMany() && r.isUnsettable()) {
            o.eSet((EStructuralFeature)r, null);
        } else {
            List value = MergeHelper.getEObjectList((Resource)this.resource, (List)rl.getRef());
            ((List)o.eGet((EStructuralFeature)r)).removeAll(value);
        }
    }
}

