/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.activemq.ws.xmlbeans.notification.base.NotificationMessageHolderType;
import org.activemq.ws.xmlbeans.notification.base.NotifyDocument;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;
import org.apache.axis.types.URI;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.SerializedNotification;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.Notify;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.Subscribe;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.SubscribeResponse;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.TopicExpressionType;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BrokeredNotification_1_2_draft_01_wsdl.NotificationBroker;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BrokeredNotification_1_2_draft_01_wsdl.NotificationBrokerServiceLocator;
import org.w3c.dom.CharacterData;
import org.xmlsoap.schemas.ws._2003._03.addressing.AttributedURI;
import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;

public class NotificationServiceUtil {
    private static Logger logger;
    private static String nb;
    private static String sid;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotificationServiceUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        nb = null;
        sid = null;
    }

    private static void subscribeTopic(String notificationBrokerUrl, String notificationConsumerEndpoint, String topic) throws NotifServiceNotAvailableException {
        try {
            NotificationBroker broker = new NotificationBrokerServiceLocator().getWsbnwNotificationBroker(new URL(notificationBrokerUrl));
            EndpointReferenceType endpoint = new EndpointReferenceType();
            endpoint.setAddress(new AttributedURI(notificationConsumerEndpoint));
            Subscribe subscribeData = new Subscribe();
            subscribeData.setConsumerReference(endpoint);
            MessageElement[] elements = new MessageElement[]{new MessageElement((CharacterData)new Text(topic))};
            TopicExpressionType topicExpressionType = new TopicExpressionType(elements, new URI("http://www.ibm.com/xmlns/stdwip/web-services/WSTopics/TopicExpression/simple"));
            subscribeData.setTopicExpression(topicExpressionType);
            SubscribeResponse r = broker.subscribe(subscribeData);
            logger.debug((Object)("NS endpoint ref type:" + r.getSubscriptionReference().getReferenceProperties().get_any()));
            MessageElement[] els = r.getSubscriptionReference().getReferenceProperties().get_any();
            int i = 0;
            while (i < els.length) {
                logger.debug((Object)("els:[" + i + "]=" + els[i].toString()));
                ++i;
            }
            nb = notificationBrokerUrl;
            sid = els[0].toString();
        }
        catch (Exception e) {
            throw new NotifServiceNotAvailableException(e.toString(), e);
        }
    }

    public static void subscribe(String notificationBrokerEndpoint, String notificationConsumerEndpoint, String[] topics) throws NotifServiceNotAvailableException {
        int i = 0;
        while (i < topics.length) {
            NotificationServiceUtil.subscribeTopic(notificationBrokerEndpoint, notificationConsumerEndpoint, topics[i]);
            ++i;
        }
    }

    public static void unsubscribe() {
        String destroyMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>   <soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:wsrl=\"http://docs.oasis-open.org/wsrf/2004/11/wsrf-WS-ResourceLifetime-1.2-draft-04.xsd\" xmlns:ex=\"http://example.com/exampleNS\"> <soapenv:Header> <wsa:Action soapenv:mustUnderstand=\"0\"> http://docs.oasis-open.org/wsrf/2004/11/wsrf-WS-ResourceLifetime-1.2-draft-04.xsd </wsa:Action> <wsa:To soapenv:mustUnderstand=\"0\">NB_ENDPOINT</wsa:To><ex:ResourceID> SUBSCRIBER_ID</ex:ResourceID>      </soapenv:Header>      <soapenv:Body>\t\t<wsrl:Destroy/>     </soapenv:Body>   </soapenv:Envelope>";
        destroyMsg = destroyMsg.replaceAll("NB_ENDPOINT", nb);
        destroyMsg = destroyMsg.replaceAll("SUBSCRIBER_ID", sid);
        try {
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage smsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(destroyMsg.getBytes()));
            SOAPPart sp = smsg.getSOAPPart();
            sp.getEnvelope();
            SOAPConnection conn = SOAPConnectionFactory.newInstance().createConnection();
            logger.debug((Object)("Connecting to uri:" + nb));
            SOAPMessage response = conn.call(smsg, (Object)nb);
            System.out.println(response.getSOAPBody().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void publish(String notificationBrokerEndpoint, String topicExpression, String message) {
        try {
            MessageElement element = new MessageElement((CharacterData)new Text(topicExpression));
            TopicExpressionType topicExpressionType = new TopicExpressionType(new MessageElement[]{element}, new URI("http://www.ibm.com/xmlns/stdwip/web-services/WSTopics/TopicExpression/simple"));
            org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.NotificationMessageHolderType notificationMessageHolderType = new org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.NotificationMessageHolderType(topicExpressionType, null, (Object)message);
            Notify notify = new Notify(new org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.NotificationMessageHolderType[]{notificationMessageHolderType});
            NotificationBroker broker = new NotificationBrokerServiceLocator().getWsbnwNotificationBroker(new URL(notificationBrokerEndpoint));
            broker.notify(notify);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SerializedNotification[] extractNotifications(SOAPBody body) {
        String bodyString = body.getChildNodes().item(0).toString();
        NotifyDocument notifyDocument = null;
        try {
            notifyDocument = NotifyDocument.Factory.parse((String)bodyString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NotificationMessageHolderType[] notificationMessages = notifyDocument.getNotify().getNotificationMessageArray();
        SerializedNotification[] results = new SerializedNotification[notificationMessages.length];
        int i = 0;
        while (i < notificationMessages.length) {
            results[i] = new SerializedNotification();
            results[i].message = notificationMessages[i].getMessage().getDomNode().getFirstChild().getNodeValue();
            results[i].topic = notificationMessages[i].getTopic().getDomNode().getFirstChild().getNodeValue();
            ++i;
        }
        return results;
    }
}

