/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.registry;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ToolSelectionStrategy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.AlreadyRegistered;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.NotFound;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.WebRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.WebRegistryServiceLocator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.uml2.impl.UML2PackageImpl;

public class RegistryClient {
    String registry_location;
    WebRegistry registry;
    private static Logger logger;
    Collection tools = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public RegistryClient(String _registry_location) throws RegistryNotAvailableException {
        LoggerConfigurator.configure();
        try {
            this.registry_location = _registry_location;
            WebRegistryServiceLocator loc = new WebRegistryServiceLocator();
            this.registry = loc.getWebRegistry(new URL(this.registry_location));
        }
        catch (Exception e) {
            throw new RegistryNotAvailableException("URL= [" + this.registry_location + "]", e);
        }
    }

    public Tool lookupToolByModelingService(String serviceName, ToolSelectionStrategy selector) throws RegistryNotAvailableException {
        Tool t = null;
        if (this.tools != null) {
            t = selector.selectTool(serviceName, this.tools);
        }
        if (t != null) {
            return t;
        }
        this.loadDescriptionsFromRegistry(serviceName);
        t = selector.selectTool(serviceName, this.tools);
        return t;
    }

    public Collection getCachedToolDescription() throws RegistryNotAvailableException {
        if (this.tools == null) {
            this.loadDescriptionsFromRegistry();
        }
        return this.tools;
    }

    public void loadDescriptionsFromRegistry() throws RegistryNotAvailableException {
        try {
            String[] results = this.registry.lookupAllModelingServiceInterfaces();
            Collection col = this.toEmf(results);
            col = this.toEmf(results);
            Collection modelingServiceInterfaces = ModelUtil.findElementByType(col, "ModelingServiceInterface");
            Iterator it = modelingServiceInterfaces.iterator();
            while (it.hasNext()) {
                ModelingServiceInterface interf = (ModelingServiceInterface)it.next();
                results = this.registry.lookupToolsByModelingServiceInterface(interf.getName());
                col = this.toEmf(results);
                Collection _tools = ModelUtil.findElementByType(col, "Tool");
                this.tools.addAll(_tools);
                RegistryClient.registerResources(_tools);
            }
        }
        catch (RemoteException e) {
            if (e instanceof AxisFault) {
                logger.error((Object)("Looking up: " + ((AxisFault)e).dumpToString()));
                throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
            }
            logger.error((Object)"RemoteException:", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)"IOException:", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void loadDescriptionsFromRegistry(String serviceName) throws RegistryNotAvailableException {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        if (qname.interfaceName == null) {
            this.loadDescriptionsFromRegistry();
            return;
        }
        String[] results = null;
        try {
            results = this.registry.lookupToolsByModelingServiceInterface(qname.interfaceName);
        }
        catch (NotFound e) {
            logger.error((Object)"NotFound:", (Throwable)((Object)e));
            e.printStackTrace();
        }
        catch (RemoteException e) {
            if (e instanceof AxisFault) {
                logger.error((Object)("Looking up: " + ((AxisFault)e).dumpToString()));
                throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
            }
            logger.error((Object)"RemoteException:", (Throwable)e);
            e.printStackTrace();
        }
        Collection col = null;
        try {
            col = this.toEmf(results);
        }
        catch (IOException e1) {
            logger.error((Object)"IOException:", (Throwable)e1);
            e1.printStackTrace();
        }
        Collection _tools = ModelUtil.findElementByType(col, "Tool");
        this.tools.addAll(_tools);
        RegistryClient.registerResources(_tools);
    }

    private Collection toEmf(String[] results) throws IOException {
        logger.debug((Object)"Registry lookup result: ");
        int i = 0;
        while (i < results.length) {
            logger.debug((Object)results[i]);
            ++i;
        }
        Vector<String> strings = new Vector<String>();
        int i2 = 0;
        while (i2 < results.length) {
            strings.add(results[i2]);
            ++i2;
        }
        Collection emfobjs = new Xmi2EmfConversion().convertFromStrings(strings, false);
        return emfobjs;
    }

    public String registerTool(Tool desc) throws RegistryNotAvailableException {
        String token = new String();
        try {
            Vector<Tool> emfobjs = new Vector<Tool>();
            emfobjs.add(desc);
            String s = Emf2XmiConversion.convertToString(emfobjs);
            token = this.registry.registerTool(s);
            return token;
        }
        catch (Exception e) {
            if (e instanceof AlreadyRegistered) {
                logger.warn((Object)"Registering: Modeling Service is already registred");
                return token;
            }
            if (e instanceof AxisFault) {
                logger.error((Object)("Registry not available: Fault at the remote site " + ((AxisFault)e).dumpToString()));
                throw new RegistryNotAvailableException("URL= [" + this.registry_location + "]", e);
            }
            logger.error((Object)"Registry not available");
            throw new RegistryNotAvailableException("URL= [" + this.registry_location + "]", e);
        }
    }

    public void deregisterTool(String token) throws RegistryNotAvailableException {
        try {
            this.registry.deregisterTool(token);
        }
        catch (Exception e) {
            throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Collection getTools() {
        return this.tools;
    }

    public static void registerResources(Tool tool) {
        ModelingServiceInterface msi = tool.getInterface();
        Iterator it = msi.getService().iterator();
        while (it.hasNext()) {
            ModelingService ms = (ModelingService)it.next();
            Iterator it2 = ms.getParameter().iterator();
            while (it2.hasNext()) {
                EPackage metamodel;
                Parameter param = (Parameter)it2.next();
                Type type = param.getType();
                if (!(type instanceof ModelType) || (metamodel = RegistryClient.getMetaModel((ModelType)type)) == null) continue;
                RegistryClient.registerMetaModel(metamodel);
            }
            Iterator it3 = ms.getServiceError().iterator();
            while (it3.hasNext()) {
                EPackage metamodel;
                Error error = (Error)it3.next();
                Type type = error.getType();
                if (!(type instanceof ModelType) || (metamodel = RegistryClient.getMetaModel((ModelType)type)) == null) continue;
                RegistryClient.registerMetaModel(metamodel);
            }
        }
    }

    public static void registerResources(Collection tools) {
        Iterator it = tools.iterator();
        while (it.hasNext()) {
            Tool t = (Tool)it.next();
            RegistryClient.registerResources(t);
        }
    }

    private static EPackage getMetaModel(ModelType type) {
        ModelType mtype = type;
        Iterator meta_it = mtype.getContent().iterator();
        if (meta_it.hasNext()) {
            MetaclassSpecification metaspec = (MetaclassSpecification)meta_it.next();
            EClass metaclass = metaspec.getMetaClass();
            EPackage metamodel = RegistryClient.getMetaModel(metaclass.getEPackage());
            return metamodel;
        }
        return null;
    }

    private static EPackage getMetaModel(EPackage pack) {
        EPackage next_pack = pack.getESuperPackage();
        UML2PackageImpl.init();
        while (next_pack != null) {
            pack = next_pack;
            next_pack = pack.getESuperPackage();
        }
        return pack;
    }

    private static void registerMetaModel(EPackage metamodel) {
        EPackage registered;
        String uri = metamodel.getNsURI();
        if (uri == null || "".equals(uri)) {
            EPackage superp = metamodel.getESuperPackage();
            uri = superp == null ? "http://model/" + metamodel.getName() : String.valueOf(superp.getNsURI()) + "/" + metamodel.getName();
            metamodel.setNsURI(uri);
        }
        if ((registered = EPackage.Registry.INSTANCE.getEPackage(metamodel.getNsURI())) != null && registered != metamodel) {
            logger.warn((Object)("The EPackage with NS URI " + metamodel.getNsURI() + " is already loaded! \n" + "It will be kept unchanged, though ModelBus Registry can contain an updated version."));
            return;
        }
        logger.debug((Object)("Registring NS URI = " + metamodel.getNsURI() + "\for EPackage" + metamodel));
        EPackage.Registry.INSTANCE.put((Object)metamodel.getNsURI(), (Object)metamodel);
        Iterator it = metamodel.getESubpackages().iterator();
        while (it.hasNext()) {
            EPackage subp = (EPackage)it.next();
            RegistryClient.registerMetaModel(subp);
        }
    }
}

