/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelElementReference;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public abstract class AbstractBasicModelSerializer
implements ModelSerializer {
    private static Logger logger;
    protected Map model_uri = new WeakHashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.AbstractBasicModelSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public SerializedXmiDocument[] serialize(Parameter[] params, Object[] values) {
        Vector<SerializedXmiDocument> docVector = new Vector<SerializedXmiDocument>();
        int i = 0;
        while (i < params.length) {
            if (params[i].getType() instanceof ModelType) {
                if (params[i].getUpper() != 1) {
                    Object[] array = (Object[])values[i];
                    int j = 0;
                    while (j < array.length) {
                        SerializedXmiDocument doc = this.serializeDocument(String.valueOf(params[i].getName()) + "." + j, array[j]);
                        docVector.add(doc);
                        ++j;
                    }
                } else {
                    SerializedXmiDocument doc = this.serializeDocument(params[i].getName(), values[i]);
                    docVector.add(doc);
                }
            }
            ++i;
        }
        return docVector.toArray(new SerializedXmiDocument[docVector.size()]);
    }

    SerializedXmiDocument serializeDocument(String uri, Object value) {
        SerializedXmiDocument doc = new SerializedXmiDocument();
        doc.setUri(uri);
        this.model_uri.put(value, uri);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.serialize(value, out);
            doc.setXmi(out.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return doc;
    }

    protected abstract void serialize(Object var1, OutputStream var2);

    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = new DeserializedModel[documents.length];
        int i = 0;
        while (i < documents.length) {
            result[i] = new DeserializedModel();
            result[i].setUri(documents[i].getUri());
            try {
                ByteArrayInputStream bin = new ByteArrayInputStream(documents[i].getXmi().getBytes());
                Object o = this.deserialize(bin);
                result[i].setValue(o);
            }
            catch (Exception e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    protected abstract Object deserialize(InputStream var1);

    public ModelElementReference[] getReferences(SerializedXmiDocument[] documents, Parameter p, Object o) {
        ModelElementReference[] result = new ModelElementReference[]{new ModelElementReference()};
        result[0].setUri((String)this.model_uri.get(o));
        result[0].setRef("/");
        return result;
    }

    public Object dereference(DeserializedModel[] data, Parameter p, ModelElementReference[] refs) {
        new Vector();
        String uri = refs[0].getUri();
        int j = 0;
        while (j < data.length) {
            if (data[j].getUri().equals(uri)) {
                return data[j].getValue();
            }
            ++j;
        }
        logger.error((Object)("Resource Not Found " + uri));
        return null;
    }
}

