/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.XmiUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModelDeserializer {
    public static final String XMI_NS = "http://www.omg.org/XMI";
    public static DocumentBuilder docBuilder = null;
    private static Logger logger;
    String format = "EMF";
    MBXmiResource resource;
    Collection createdModelElements = new Vector();
    List links = new Vector();

    static {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException("XML Parser cannot be initialized", e);
        }
        logger = Logger.getLogger((String)"ModelDeserializer");
    }

    public ModelDeserializer() {
        this(new MBXmiResource(URI.createURI((String)"uri1")));
    }

    public ModelDeserializer(MBXmiResource res) {
        this.resource = res;
    }

    public void deserialize(InputStream in) throws SAXException, IOException, XMIException {
        Document doc = XmiUtil.parseXml(in);
        this.createModelElementsFromRootXml(doc.getDocumentElement());
        this.resolveLinks();
    }

    public void deserialize(String xmi) throws SAXException, IOException, XMIException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmi.getBytes());
        this.deserialize(in);
    }

    void resolveLinks() {
        ModelDeserializer.resolveLinks(this.links, this.resource);
    }

    public void createModelElementsFromRootXml(Element rootElem) throws XMIException {
        NodeList list = rootElem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                Element xmlElem = (Element)list.item(i);
                EObject o = this.createModelElementFrom(xmlElem);
                this.resource.getContents().add((Object)o);
            }
            ++i;
        }
    }

    EObject createModelElementFrom(Element xmlElem) throws XMIException {
        String type = null;
        type = xmlElem.hasAttribute("xmi:type") ? xmlElem.getAttribute("xmi:type") : xmlElem.getTagName();
        String prefix = ModelDeserializer.getNsPrefix(type);
        String className = ModelDeserializer.getLocalName(type);
        String uri = ModelDeserializer.lookupNamespace(xmlElem, prefix);
        EPackage p = this.getPackageFromURI(uri);
        if (p == null) {
            throw new PackageNotFoundException(String.valueOf(uri) + "(" + type + ")", "element:" + xmlElem, 0, 0);
        }
        EClass c = (EClass)p.getEClassifier(className);
        if (c == null) {
            throw new ClassNotFoundException(className, null, "element:" + xmlElem, 0, 0);
        }
        EObject o = EcoreUtil.create((EClass)c);
        this.createdModelElements.add(o);
        String xmiid = xmlElem.getAttribute("xmi:id");
        if (xmiid.equals("")) {
            ModelDeserializer.printErrMessage("No id for " + xmlElem);
        } else {
            this.resource.getIdTable().assignId(xmiid, o);
        }
        this.setFeatures(o, xmlElem);
        return o;
    }

    EPackage getPackageFromURI(String uri) {
        System.out.println("Uri: " + uri);
        EPackage p = EPackage.Registry.INSTANCE.getEPackage(uri);
        if (p == null) {
            Resource r = this.resource.getResourceSet().getResource(URI.createURI((String)uri), true);
            ModelBusResourceSet.registerEPackages(r);
            p = EPackage.Registry.INSTANCE.getEPackage(uri);
        }
        return p;
    }

    void setFeatures(EObject o, Element xmlElem) throws XMIException {
        Object value;
        EAttribute watt;
        EClass c = o.eClass();
        NamedNodeMap map = xmlElem.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Node n = map.item(i);
            String attName = n.getNodeName();
            String attNsPrefix = ModelDeserializer.getNsPrefix(attName);
            ModelDeserializer.getLocalName(attName);
            String attValue = n.getNodeValue();
            if (attNsPrefix.length() > 0) {
                if (!attName.equals("xmi:id") && !attName.equals("xmi:type")) {
                    ModelDeserializer.printErrMessage("Unknown attribute " + attName);
                }
            } else {
                watt = (EAttribute)c.getEStructuralFeature(attName);
                if (watt == null) {
                    ModelDeserializer.printErrMessage("Unknown attribute " + attName);
                } else {
                    value = EcoreUtil.createFromString((EDataType)watt.getEAttributeType(), (String)attValue);
                    o.eSet((EStructuralFeature)watt, value);
                }
            }
            ++i;
        }
        NodeList list = xmlElem.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            if (list.item(i2) instanceof Element) {
                Element subXmlElem = (Element)list.item(i2);
                String elemName = subXmlElem.getTagName();
                EStructuralFeature f = c.getEStructuralFeature(elemName);
                if (f == null) {
                    ModelDeserializer.printErrMessage("Unknown feature " + elemName);
                }
                if (f instanceof EAttribute) {
                    watt = (EAttribute)f;
                    String text = subXmlElem.getFirstChild().getNodeValue();
                    Object value2 = EcoreUtil.createFromString((EDataType)watt.getEAttributeType(), (String)text);
                    if (watt.isMany()) {
                        List l = (List)o.eGet((EStructuralFeature)watt);
                        l.add(value2);
                    } else {
                        o.eSet((EStructuralFeature)watt, value2);
                    }
                } else if (f instanceof EReference) {
                    EReference r = (EReference)f;
                    if (subXmlElem.hasAttribute("xmi:action") && subXmlElem.hasAttribute("href")) {
                        this.updateReference(o, r, subXmlElem);
                    } else if (subXmlElem.hasAttribute("href")) {
                        String idref = subXmlElem.getAttribute("href");
                        this.links.add(new Link(r, o, idref));
                    } else {
                        value = this.createModelElementFrom(subXmlElem);
                        if (r.isMany()) {
                            List l = (List)o.eGet((EStructuralFeature)r);
                            l.add(value);
                        } else {
                            o.eSet((EStructuralFeature)r, value);
                        }
                    }
                }
            }
            ++i2;
        }
    }

    void updateReference(EObject o, EReference r, Element refXmlElem) {
        String action = refXmlElem.getAttribute("xmi:action");
        String id = refXmlElem.getAttribute("href");
        EObject referencedElem = this.resource.getIdTable().getModelElement(id);
        List l = (List)o.eGet((EStructuralFeature)r);
        if (action.equals("add")) {
            l.add(referencedElem);
        } else if (action.equals("remove")) {
            l.remove(referencedElem);
        }
    }

    static String getNsPrefix(String colontag) {
        return colontag.indexOf(58) < 0 ? "" : colontag.substring(0, colontag.indexOf(58));
    }

    static String getLocalName(String colontag) {
        return colontag.substring(colontag.indexOf(58) + 1);
    }

    static String lookupNamespace(Element xmlElem, String prefix) {
        String attName = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        Element topElem = xmlElem;
        String uri = topElem.getAttribute(attName);
        while (uri.equals("") && topElem.getParentNode() instanceof Element) {
            topElem = (Element)topElem.getParentNode();
            uri = topElem.getAttribute("xmlns:" + prefix);
        }
        return uri;
    }

    static void printErrMessage(String s) {
        logger.error((Object)s);
    }

    public Collection getCreatedModelElements() {
        return this.createdModelElements;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    static void resolveLinks(Collection links, MBXmiResource res) {
        Iterator it = links.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            String id = ModelDeserializer.getIdPart(link.href);
            String uri = ModelDeserializer.getUriPart(link.href);
            EObject value = null;
            ResourceSet rs = null;
            Resource refRes = null;
            if (uri == null) {
                value = res.getIdTable().getModelElement(id);
            } else {
                rs = res.getResourceSet();
                refRes = rs.getResource(URI.createURI((String)uri), true);
                value = refRes.getEObject(id);
            }
            if (value == null) {
                ModelDeserializer.printErrMessage("Element not found href=" + link.href);
                if (rs == null) continue;
                ModelDeserializer.printErrMessage("RS: " + rs.toString());
                ModelDeserializer.printErrMessage("Resource: " + refRes.toString() + " " + refRes.getContents());
                continue;
            }
            if (link.eReference.isMany()) {
                List values = (List)link.modelElement.eGet((EStructuralFeature)link.eReference);
                values.add(value);
                continue;
            }
            link.modelElement.eSet((EStructuralFeature)link.eReference, (Object)value);
        }
        links.clear();
    }

    public static String getUriPart(String href) {
        int i = href.indexOf(35);
        if (i == -1) {
            return null;
        }
        return href.substring(0, i);
    }

    public static String getIdPart(String href) {
        int i = href.indexOf(35);
        if (i == -1) {
            return href;
        }
        return href.substring(i + 1, href.length());
    }

    public MBXmiResource getResource() {
        return this.resource;
    }

    public void setResource(MBXmiResource resource) {
        this.resource = resource;
    }

    static class Link {
        EReference eReference;
        EObject modelElement;
        String href;

        Link(EReference r, EObject o, String href) {
            this.eReference = r;
            this.modelElement = o;
            this.href = href;
        }
    }
}

