/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.uml2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.Uml2ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.DefaultModelSerializer;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.UML2Package;

public class ProfiledModelSerializer
extends DefaultModelSerializer {
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.uml2.ProfiledModelSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public ProfiledModelSerializer() {
        this.ignoredUriPrefixSet.add("pathmap://UML2_PROFILES");
        this.ignoredUriPrefixSet.add("pathmap://UML2_LIBRARIES");
        this.ignoredUriPrefixSet.add("pathmap://UML2_METAMODELS");
    }

    public SerializedXmiDocument[] serialize(Parameter[] params, Object[] values) {
        Collection allModelElements = this.getScope(params, values);
        Resource[] res = ModelUtil.getResourcesFromObjects(allModelElements, this.skipCrossReferences, this.ignoredUriPrefixSet);
        Vector<Resource> list = new Vector<Resource>(Arrays.asList(res));
        int i = 0;
        while (i < res.length) {
            res[i] = this.getProfileResourceFirst(list);
            ++i;
        }
        return this.serializeResources(res);
    }

    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = new DeserializedModel[documents.length];
        ModelBusResourceSet rs = new ModelBusResourceSet();
        int i = 0;
        while (i < documents.length) {
            result[i] = new DeserializedModel();
            result[i].setUri(documents[i].getUri());
            try {
                ByteArrayInputStream bin = new ByteArrayInputStream(documents[i].getXmi().getBytes());
                Resource r = rs.createResource(URI.createURI((String)documents[i].getUri()));
                r.load((InputStream)bin, null);
                result[i].setValue(r);
                Profile p = ProfiledModelSerializer.getContainedProfile(r);
                if (p != null) {
                    Uml2ModelUtil.registerEcorePackagesOfProfile(p);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            ++i;
        }
        return result;
    }

    Resource getProfileResourceFirst(Collection c) {
        Resource r;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            r = (Resource)it.next();
            Profile p = ProfiledModelSerializer.getContainedProfile(r);
            if (p == null) continue;
            c.remove(r);
            return r;
        }
        if (c.isEmpty()) {
            return null;
        }
        r = (Resource)c.iterator().next();
        c.remove(r);
        return r;
    }

    public static Profile getContainedProfile(Resource r) {
        Profile profile = (Profile)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)UML2Package.eINSTANCE.getProfile());
        return profile;
    }
}

