/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalSessionInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultSessionWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultSessionWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.WsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class TransportManager {
    private static Logger logger;
    SessionManager sessionManager = new SessionManager();
    Map toolDesc_proxy = new Hashtable();
    AdapterStub adapter;
    ModelSerializer modelSerializer = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.TransportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public TransportManager(AdapterStub adapter) {
        this.adapter = adapter;
    }

    public ProviderProxy getProviderProxy(Tool t) {
        DefaultWsInvocationSender p = null;
        if (AdapterContainerImpl.getInstance().containsTool(t)) {
            logger.debug((Object)"Local Call");
            p = new LocalInvocationSender(this.adapter.getProperties());
        } else {
            p = new DefaultWsInvocationSender(this.adapter.getProperties());
        }
        p.setToolDescription(t);
        if (this.modelSerializer != null) {
            logger.debug((Object)("setSerializer" + this.modelSerializer.getClass().getName()));
            p.getMarshaler().setSerializer(this.modelSerializer);
        }
        return p;
    }

    public SessionProviderProxy getSessionProviderProxy(Tool t) {
        DefaultSessionWsInvocationSender p = null;
        if (!DescriptionUtil.getIsSessionEnabled(t)) {
            return p;
        }
        p = AdapterContainerImpl.getInstance().containsTool(t) ? new LocalSessionInvocationSender(this.adapter.getProperties()) : new DefaultSessionWsInvocationSender(this.adapter.getProperties());
        p.setSessionManager(this.sessionManager);
        p.setToolDescription(t);
        if (this.modelSerializer != null) {
            p.getMarshaler().setSerializer(this.modelSerializer);
        }
        return p;
    }

    public void removeProviderProxy(ProviderProxy p) {
        this.toolDesc_proxy.values().remove(p);
    }

    public Collection getAllProviderProxies() {
        return this.toolDesc_proxy.values();
    }

    public WsInvocationReceiver getWsInvocationReceiver() {
        this.adapter.getProperties().getProperty("marshal.invocationStyle", "default");
        DefaultWsInvocationReceiver r = DescriptionUtil.getIsSessionEnabled(this.adapter.getToolDescription()) ? new DefaultSessionWsInvocationReceiver(this.adapter) : new DefaultWsInvocationReceiver(this.adapter);
        if (this.modelSerializer != null) {
            logger.debug((Object)("setSerializer " + this.modelSerializer.getClass().getName()));
            r.getMarshaler().setSerializer(this.modelSerializer);
        }
        return r;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public ModelSerializer getModelSerializer() {
        return this.modelSerializer;
    }

    public void setModelSerializer(ModelSerializer modelSerializer) {
        this.modelSerializer = modelSerializer;
    }
}

