/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.axis.message.PrefixedQName;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelElementReference;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.DefaultModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.Marshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.TypeMismatchException;
import org.eclipse.mddi.modelbus.description.abstract_.EnumerationType;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractFactoryImpl;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DefaultMarshaler
implements Marshaler {
    public static final String ERROR_INFO_TAG = "ErrorInfo";
    public static final String ERROR_FULL_TAG = "modelbus:ModelingServiceError";
    public static final String ERROR_TAG = "ModelingServiceError";
    public static final String SCOPE_TAG = "modelbus:Scope";
    public static final String MB_STRING = "string";
    public static final String MB_INTEGER = "integer";
    public static final String MB_BOOLEAN = "boolean";
    public static final String MB_DOUBLE = "double";
    public static final String MB_BINARY = "binary";
    private static Logger logger;
    SerializedXmiDocument[] docs;
    DeserializedModel[] models;
    ModelSerializer serializer = new DefaultModelSerializer();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.DefaultMarshaler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public DefaultMarshaler(Properties p) {
    }

    public void marshal(Parameter p, Object parameterValue, SOAPElement topElem) throws Exception {
        if (parameterValue == null) {
            return;
        }
        SOAPElement paramSoapElem = topElem.addChildElement(p.getName());
        if (p.getUpper() != 1) {
            if (!(parameterValue instanceof Object[])) {
                throw new SOAPException("Marshall error, invalid parameter multiplicity - " + p.getName());
            }
            Object[] values = (Object[])parameterValue;
            int i = 0;
            while (i < values.length) {
                Object singleValue = values[i];
                SOAPElement itemElem = paramSoapElem.addChildElement("modelbus:item");
                this.marshallSingleValue(p, singleValue, itemElem);
                ++i;
            }
        } else {
            this.marshallSingleValue(p, parameterValue, paramSoapElem);
        }
    }

    void marshallSingleValue(Parameter p, Object value, SOAPElement elem) throws Exception {
        Type t = p.getType();
        if (t instanceof ModelType) {
            ModelElementReference[] refs = this.serializer.getReferences(this.docs, p, value);
            int i = 0;
            while (i < refs.length) {
                SOAPElement elem1 = elem.addChildElement("modelbus:Ref");
                elem1.setAttribute("uri", refs[i].getUri());
                elem1.setAttribute("fragment", refs[i].getRef());
                ++i;
            }
            DefaultMarshaler.setEncodingStyle(p, elem);
        } else if (t instanceof EnumerationType) {
            String s = value.toString();
            DefaultMarshaler.setEncodingStyle(p, elem);
            elem.addTextNode(s);
        } else if (t.getName().equalsIgnoreCase(MB_BINARY)) {
            if (!(value instanceof InputStream)) {
                throw new TypeMismatchException("Binary parameters should be of java.io.InputStream type");
            }
            BASE64Encoder encoder = new BASE64Encoder();
            InputStream is = (InputStream)value;
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            String s = encoder.encode(buffer);
            DefaultMarshaler.setEncodingStyle(p, elem);
            elem.addTextNode(s);
        } else {
            String s = value.toString();
            DefaultMarshaler.setEncodingStyle(p, elem);
            elem.addTextNode(s);
        }
    }

    public static void setEncodingStyle(Parameter p, SOAPElement elem) throws SOAPException {
        Type t = p.getType();
        String typeName = t.getName();
        if (t instanceof PrimitiveType) {
            if (typeName.equalsIgnoreCase(MB_STRING)) {
                elem.setAttribute("encoding", "xsd:string");
            } else if (typeName.equalsIgnoreCase(MB_INTEGER)) {
                elem.setAttribute("encoding", "xsd:integer");
            } else if (typeName.equalsIgnoreCase(MB_DOUBLE)) {
                elem.setAttribute("encoding", "xsd:float");
            } else if (typeName.equalsIgnoreCase(MB_BOOLEAN)) {
                elem.setAttribute("encoding", "xsd:boolean");
            } else if (typeName.equalsIgnoreCase(MB_BINARY)) {
                elem.setAttribute("encoding", "xsd:base64Binary");
            } else {
                elem.setEncodingStyle(t.getName());
            }
        } else if (t instanceof ModelType) {
            elem.setAttribute("encoding", "modelbus:ModelEncoding");
        } else if (t instanceof EnumerationType) {
            elem.setAttribute("encoding", "modelbus:Enumeration");
        }
    }

    public Object unmarshal(Parameter p, SOAPElement topElem) throws Exception {
        SOAPElement elem = SoapUtil.getChildByLocalName(topElem, p.getName());
        if (elem == null) {
            return null;
        }
        if (p.getUpper() != 1) {
            Vector<Object> values = new Vector<Object>();
            Iterator it = elem.getChildElements();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SOAPElement)) continue;
                SOAPElement subElem = (SOAPElement)o;
                Object v = this.unmarshallSingleValue(p, subElem);
                values.add(v);
            }
            Object[] array = DefaultMarshaler.getArrayForMultiValueParameter(p, values.size());
            return values.toArray(array);
        }
        return this.unmarshallSingleValue(p, elem);
    }

    static Object[] getArrayForMultiValueParameter(Parameter p, int size) {
        Type t = p.getType();
        if (t instanceof PrimitiveType) {
            String typeName = t.getName();
            if (typeName.equalsIgnoreCase(MB_STRING)) {
                return new String[size];
            }
            if (typeName.equalsIgnoreCase(MB_INTEGER)) {
                return new Integer[size];
            }
            if (typeName.equalsIgnoreCase(MB_DOUBLE)) {
                return new Double[size];
            }
            if (typeName.equalsIgnoreCase(MB_BOOLEAN)) {
                return new Boolean[size];
            }
            if (typeName.equalsIgnoreCase(MB_BINARY)) {
                return new ByteArrayInputStream[size];
            }
            return null;
        }
        if (t instanceof EnumerationType) {
            return new String[size];
        }
        if (t instanceof ModelType) {
            return new Collection[size];
        }
        return null;
    }

    Object unmarshallSingleValue(Parameter p, SOAPElement elem) throws Exception {
        Type t = p.getType();
        if (t instanceof ModelType) {
            Vector<ModelElementReference> v = new Vector<ModelElementReference>();
            Iterator it = elem.getChildElements();
            while (it.hasNext()) {
                SOAPElement elem1 = (SOAPElement)it.next();
                ModelElementReference r = new ModelElementReference();
                v.add(r);
                r.setUri(elem1.getAttribute("uri"));
                r.setRef(elem1.getAttribute("fragment"));
            }
            ModelElementReference[] refs = v.toArray(new ModelElementReference[v.size()]);
            Object o = this.serializer.dereference(this.models, p, refs);
            return o;
        }
        if (t instanceof EnumerationType) {
            String value = elem.getValue();
            return value;
        }
        String typeName = t.getName();
        String value = elem.getValue();
        if (typeName.equalsIgnoreCase(MB_STRING)) {
            return value;
        }
        if (typeName.equalsIgnoreCase(MB_INTEGER)) {
            return new Integer(Integer.parseInt(value));
        }
        if (typeName.equalsIgnoreCase(MB_DOUBLE)) {
            return new Double(Double.parseDouble(value));
        }
        if (typeName.equalsIgnoreCase(MB_BOOLEAN)) {
            return Boolean.valueOf(value);
        }
        if (typeName.equalsIgnoreCase(MB_BINARY)) {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] buffer = decoder.decodeBuffer(value);
            return new ByteArrayInputStream(buffer);
        }
        throw new Exception("Deserialize error, unknown Type " + t);
    }

    public void marshalModelingServiceError(ModelingServiceError err, SOAPFault f) throws SOAPException {
        PrefixedQName n1 = new PrefixedQName("http://www.eclipse.org/mddi/modelbus", ERROR_INFO_TAG, "modelbus");
        f.setFaultCode(ERROR_TAG);
        f.setFaultString(err.getName());
        if (err.getInfo() != null) {
            Detail detail = f.addDetail();
            DetailEntry entry = detail.addDetailEntry((Name)n1);
            if (err.getErrorType() == null) {
                entry.addTextNode(err.getInfo().toString());
            } else {
                try {
                    this.marshalModelingServiceError(err.getErrorType(), err.getInfo(), (SOAPElement)entry);
                }
                catch (Exception e) {
                    throw new SOAPException((Throwable)e);
                }
            }
        }
    }

    public void marshalModelingServiceError(Error errorType, Object info, SOAPElement element) throws SOAPException, Exception {
        AbstractFactoryImpl factory = new AbstractFactoryImpl();
        Parameter parameter = factory.createParameter();
        parameter.setUpper(errorType.getUpper());
        parameter.setName(errorType.getName());
        parameter.setType(errorType.getType());
        Parameter[] params = new Parameter[]{parameter};
        Object[] values = new Object[]{info};
        this.marshal(params, values, element);
    }

    public Object unmarshalModelingServiceError(Error errorType, SOAPElement element) throws SOAPException, Exception {
        AbstractFactoryImpl factory = new AbstractFactoryImpl();
        Parameter parameter = factory.createParameter();
        parameter.setUpper(errorType.getUpper());
        parameter.setName(errorType.getName());
        parameter.setType(errorType.getType());
        Parameter[] params = new Parameter[]{parameter};
        Object[] values = this.unmarshal(params, element);
        return values[0];
    }

    public static boolean isModelingServiceError(SOAPFault f) {
        String fcode = f.getFaultCode();
        return fcode.equals(ERROR_FULL_TAG) || fcode.equals(ERROR_TAG);
    }

    public static String getModelingServiceErrorName(SOAPFault f) {
        return f.getFaultString();
    }

    public ModelingServiceError unmarshalModelingServiceError(Error errorType, SOAPFault f) throws SOAPException {
        String errName = f.getFaultString();
        PrefixedQName n1 = new PrefixedQName("http://www.eclipse.org/mddi/modelbus", ERROR_INFO_TAG, "modelbus");
        Iterator it = f.getChildElements();
        while (it.hasNext()) {
            Object info;
            SOAPElement el = (SOAPElement)it.next();
            Iterator it2 = el.getChildElements((Name)n1);
            if (!it2.hasNext()) continue;
            SOAPElement infoEl = (SOAPElement)it2.next();
            if (errorType == null) {
                String info2 = infoEl.getValue();
                return new ModelingServiceError(errName, (Object)info2);
            }
            try {
                info = this.unmarshalModelingServiceError(errorType, infoEl);
            }
            catch (Exception e) {
                throw new SOAPException((Throwable)e);
            }
            return new ModelingServiceError(errorType, info);
        }
        return new ModelingServiceError(errName, (Object)null);
    }

    public static void setNamespaces(SOAPBody body) throws SOAPException {
        body.addNamespaceDeclaration("xsd", "http://www.w3.org/1999/XMLSchema");
        body.addNamespaceDeclaration("xsi", "http://www.w3.org/1999/XMLSchema-instance");
        body.addNamespaceDeclaration("modelbus", "http://www.eclipse.org/mddi/modelbus");
    }

    public void marshal(Parameter[] params, Object[] parameterValues, SOAPElement topElem) throws Exception {
        if (params == null) {
            return;
        }
        if (parameterValues.length != params.length) {
            throw new ModelTypeMismatchException("Bad number of parameters, got " + params.length + ", expected parameters: " + DescriptionUtil.getParameterNameList(params));
        }
        SOAPElement scopeElement = topElem.addChildElement(SCOPE_TAG);
        this.docs = this.serializer.serialize(params, parameterValues);
        int i = 0;
        while (i < this.docs.length) {
            SOAPElement elem1 = scopeElement.addChildElement("modelbus:Resource");
            elem1.setAttribute("uri", this.docs[i].getUri());
            elem1.addTextNode(this.docs[i].getXmi());
            ++i;
        }
        i = 0;
        while (i < params.length) {
            this.marshal(params[i], parameterValues[i], topElem);
            ++i;
        }
        this.docs = null;
    }

    public Object[] unmarshal(Parameter[] params, SOAPElement topElem) throws Exception {
        if (params == null) {
            return null;
        }
        SOAPElement scopeElement = SoapUtil.getChildByFullName(topElem, SCOPE_TAG);
        Vector<SerializedXmiDocument> v = new Vector<SerializedXmiDocument>();
        Iterator it = scopeElement.getChildElements();
        while (it.hasNext()) {
            SOAPElement resElem = (SOAPElement)it.next();
            SerializedXmiDocument doc = new SerializedXmiDocument();
            doc.setUri(resElem.getAttribute("uri"));
            doc.setXmi(resElem.getValue());
            v.add(doc);
        }
        this.docs = v.toArray(new SerializedXmiDocument[v.size()]);
        this.models = this.serializer.deserialize(this.docs);
        Object[] unmarshaledParams = new Object[params.length];
        int i = 0;
        while (i < params.length) {
            unmarshaledParams[i] = this.unmarshal(params[i], topElem);
            ++i;
        }
        this.docs = null;
        this.models = null;
        return unmarshaledParams;
    }

    public ModelSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ModelSerializer serializer) {
        this.serializer = serializer;
    }
}

