/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.ConcretePackage;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class ProviderEndPoint
implements EndPoint {
    public static final String DEF_REL_PATH = "modeling_services";
    private static Logger logger;
    Map relativePath2AdapterMap = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ProviderEndPoint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public AdapterStub getAdapterOfProviderTool(String relativePath) {
        AdapterStub ad = (AdapterStub)this.relativePath2AdapterMap.get(relativePath);
        return ad;
    }

    public void manageAdapter(AdapterStub adapter) throws Exception {
        this.setUrlProperty(adapter);
        Tool toolDescription = adapter.getToolDescription();
        if (toolDescription == null) {
            logger.warn((Object)"Adapter: No tool description found.");
            return;
        }
        EndPointManagerImpl.getInstance().putEndPoint(DEF_REL_PATH, this);
        this.relativePath2AdapterMap.put(ProviderEndPoint.getRelativePath(toolDescription), adapter);
    }

    private void setUrlProperty(AdapterStub adapter) throws Exception {
        Tool toolDescription = adapter.getToolDescription();
        Property pro = DescriptionUtil.getPropertyObject(toolDescription, "URL");
        if (pro == null) {
            pro = ConcretePackage.eINSTANCE.getConcreteFactory().createProperty();
            toolDescription.getProperty().add((Object)pro);
        }
        int port = ServerManager.getModelBusPort(adapter);
        AbstractServer s = ServerManager.getInstance().getServer(port);
        port = s.getPort();
        pro.setName("URL");
        pro.setValue("http://" + ServerManager.getHost() + ":" + port + "/" + s.getContext() + "/" + ProviderEndPoint.getRelativePath(toolDescription));
        logger.debug((Object)("Assign URL " + pro.getValue()));
    }

    public static String getRelativePath(Tool tool) {
        String path = "modeling_services/" + tool.getName();
        return path;
    }

    public static String getRelativePath(String toolName) {
        String path = "modeling_services/" + toolName;
        return path;
    }

    public Collection getAdapters() {
        return this.relativePath2AdapterMap.values();
    }

    public void removeAdapter(AdapterStub adapter) {
        this.relativePath2AdapterMap.values().remove(adapter);
        if (this.relativePath2AdapterMap.isEmpty()) {
            EndPointManagerImpl.getInstance().removeEndPoint(DEF_REL_PATH);
            logger.debug((Object)"No provider endponts");
        }
    }

    public void execute(String relativePath, SOAPEnvelope req, SOAPEnvelope resp) throws SOAPException {
        AdapterStub a = this.getAdapterOfProviderTool(relativePath);
        if (a != null) {
            logger.debug((Object)(String.valueOf(relativePath) + " -> " + a));
            a.getTransportManager().getWsInvocationReceiver().process(req, resp);
        } else {
            logger.error((Object)("No Tool bound to the URI " + relativePath));
            logger.debug((Object)"Map has the following entries:");
            Iterator it = this.relativePath2AdapterMap.keySet().iterator();
            while (it.hasNext()) {
                logger.debug(it.next());
            }
            DefaultWsInvocationReceiver.createSoapFault(resp, "No Tool bound to the URI " + relativePath);
        }
    }
}

