/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.profile;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.Uml2ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.adapter.test.profile.ProfileSupportedTool;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Profile;

public class ProfiledModelLoaderTest {
    static String umlResourceURI = "jar:file:/D:/eclipse3.1.1/plugins/org.eclipse.uml2.resources_1.1.0.jar!/";

    public static void main(String[] args) throws Exception {
        Uml2ModelUtil.init((URI)URI.createURI((String)umlResourceURI));
        ProfiledModelLoaderTest.testProfiledModelDeserialization();
    }

    static void testLoadingProfile() throws IOException {
        ModelBusResourceSet rs = new ModelBusResourceSet();
        Resource r1 = rs.createResource(URI.createFileURI((String)"src/org/eclipse/mddi/modelbus/adapter/test/profile/MyProfile.profile.uml2"));
        Resource r2 = rs.createResource(URI.createFileURI((String)"src/org/eclipse/mddi/modelbus/adapter/test/profile/MySystem.uml2"));
        r1.load(null);
        r2.load(null);
        Model m = (Model)r2.getContents().get(0);
        ProfileSupportedTool.examineProfiledModel(m);
    }

    static void testLoadingUMLResources() throws Exception {
        ModelBusResourceSet rs = new ModelBusResourceSet();
        System.out.println("pathmap://UML2_METAMODELS/UML2.metamodel.uml2");
        Resource r = rs.getResource(URI.createURI((String)"pathmap://UML2_METAMODELS/UML2.metamodel.uml2"), true);
        System.out.println(r.getContents().get(0));
    }

    static void testProfiledModelDeserialization() throws IOException {
        Profile prof = Uml2ModelUtil.registerProfile((URI)URI.createFileURI((String)"src/org/eclipse/mddi/modelbus/adapter/test/profile/MyProfile.profile.uml2"));
        Uml2ModelUtil.setAliasURIToProfile((URI)URI.createFileURI((String)"MyProfile.profile.uml2"), (Profile)prof);
        Model m = (Model)Xmi2EmfConversion.loadFromFile((String)"src/org/eclipse/mddi/modelbus/adapter/test/profile/MySystem.uml2").get(0);
        Uml2ModelUtil.hasLink((Model)m, (Profile)prof);
        ProfileSupportedTool.examineProfiledModel(m);
    }
}

