/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 5 juil. 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.unit;


import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.uml2.impl.UML2PackageImpl;

import junit.framework.TestCase;

/**
 * Checks that models can be converted between XMI and EMF correctly
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 *
 *
 */
public class ModelConversionTest extends TestCase {
    
    private static Logger logger = Logger.getLogger(ModelConversionTest.class);

    public static void main(String[] args) {
        LoggerConfigurator.configure();
        junit.textui.TestRunner.run(ModelConversionTest.class);  
    }
    
    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        try {

        } catch(Exception e) {
            throw new Exception("TestCase can not be initialized", e);
        }
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {

    }    
    

    /**
     * Tests the conversion of UML2 model.
     * Need to have jar file for UML2 metamodel
     * (Plugin Eclipse UML2)
     * @throws IOException
     */
    public void testConvert_ecoreModel() throws IOException {
        Collection model1 = Util.createEcoreModel();
        String s = Emf2XmiConversion.convertToString(model1);
        logger.info("testConvert_ecoreModel: \n" +s +"\n\n");
        Collection model2 = Xmi2EmfConversion.convertFromString(s, true);
        
        assertTrue( Util.compareModels(model1, model2));
    
    }
 
    /**
     *  Tests the conversion of Ecore model
     * @throws IOException
     */   
    public void testConvert_umlModel() throws IOException {
        Collection model1 = Util.createUml2Model();
        String s = Emf2XmiConversion.convertToString(model1);
        logger.info("testConvert_umlModel: \n" +s +"\n\n");        
        Collection model2 = Xmi2EmfConversion.convertFromString(s, true);
        
        assertTrue( Util.compareModels(model1, model2));    
    }

    public void testConvert_uuidXmi() throws IOException {
        UML2PackageImpl.init();
        String model_file = "./src/org/eclipse/mddi/modelbus/adapter/test/unit/uuid_model.xml";
        File f = new File (model_file);
        FileInputStream fi = new FileInputStream(f);
        byte [] buffer = new byte [fi.available()];
        fi.read(buffer);
        String model = new String ( buffer);
        logger.info("Input model:"+model);
        Collection model2 = Xmi2EmfConversion.convertFromString(model , true);
        
        logger.info("Extentions model:"+model);
        
        EObject model_element = (EObject) model2.iterator().next();
        
        XMIResource res = (XMIResource) model_element.eResource();
        
        AnyType some = (AnyType) res.getEObjectToExtensionMap().get(model_element);
        
        logger.info("Extensions :"+some);

        
        assertTrue( true);    
    }


}
