/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.ConflictDetection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.DeltaQuery;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.MergeData;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.MergeHelper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergeFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLinkElement;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergePackageImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.SimpleModelLabelProvider;

public class ConflictDetectionHelper {
    static Logger logger = Logger.getLogger((String)"ConflictDetection");
    static MergeFactory fac = MergePackageImpl.init().getMergeFactory();

    public static Conflict detectConcurrentUpdatePrimitive(DeltaQuery q, ModifyPrimitive mp) {
        ModifyPrimitive mp2 = ConflictDetectionHelper.getConcurrentModifyPrimitive(q, mp);
        if (mp2 == null) {
            return null;
        }
        Conflict conf = fac.createConflict();
        conf.setType(ConflictDetection.CONCURRENT_UPDATE_PRIMITIVE);
        if (DeltaQuery.isLocalSubDelta(mp)) {
            conf.getLocal().add((Object)mp);
            conf.getRemote().add((Object)mp2);
        } else {
            conf.getLocal().add((Object)mp2);
            conf.getRemote().add((Object)mp);
        }
        return conf;
    }

    public static ModifyPrimitive getConcurrentModifyPrimitive(DeltaQuery q, ModifyPrimitive mp) {
        ModifyPrimitive mp2 = q.getModifyPrimitive(((NodeLevelSubDelta)mp.eContainer()).getId(), (EAttribute)mp.getProperty());
        if (mp2 == null) {
            return null;
        }
        if (MergeHelper.areDiffrent(mp2.getValue(), mp.getValue())) {
            return mp2;
        }
        return null;
    }

    public static Conflict detectDeleteUpdate(DeltaQuery q, Delete delete) {
        Collection col = ConflictDetectionHelper.getDeleteModifyPrimitive(q, delete);
        if (col.isEmpty()) {
            return null;
        }
        Conflict conf = fac.createConflict();
        conf.setType(ConflictDetection.DELETE_UPDATE);
        if (DeltaQuery.isLocalSubDelta(delete)) {
            conf.getLocal().add((Object)delete);
            conf.getRemote().addAll(col);
        } else {
            conf.getLocal().addAll(col);
            conf.getRemote().add((Object)delete);
        }
        return conf;
    }

    public static Collection getDeleteModifyPrimitive(DeltaQuery q, Delete delete) {
        Vector result = new Vector();
        NodeLevelSubDelta sub = q.getNodeLevelSubDelta(delete.getId());
        if (sub instanceof Delete || sub == null) {
            return result;
        }
        Iterator it = sub.getContent().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ModifyPrimitive)) continue;
            result.add(o);
        }
        return result;
    }

    public static Conflict detectOrderConflict(DeltaQuery q, ModifyLinkElement mle) {
        Collection c = null;
        if (mle instanceof InsertLink) {
            c = ConflictDetectionHelper.getOrderConflictWithInsertLink(q, (InsertLink)mle);
        } else if (mle instanceof RemoveLink) {
            c = ConflictDetectionHelper.getOrderConflictWithRemoveLink(q, (RemoveLink)mle);
        }
        if (c.isEmpty()) {
            return null;
        }
        Conflict conf = fac.createConflict();
        conf.setType(ConflictDetection.ORDER_CONFLICT);
        if (DeltaQuery.isLocalSubDelta(mle)) {
            conf.getLocal().add((Object)mle);
            conf.getRemote().addAll(c);
        } else {
            conf.getLocal().addAll(c);
            conf.getRemote().add((Object)mle);
        }
        return conf;
    }

    public static Collection getOrderConflictWithInsertLink(DeltaQuery q, InsertLink il) {
        Vector<ModifyLinkElement> result = new Vector<ModifyLinkElement>();
        ModifyLink ml1 = (ModifyLink)il.eContainer();
        if (!ml1.getProperty().isOrdered()) {
            return result;
        }
        NodeLevelSubDelta mod1 = (NodeLevelSubDelta)ml1.eContainer();
        ModifyLink ml2 = q.getModifyLink(mod1.getId(), (EReference)ml1.getProperty());
        if (ml2 == null) {
            return result;
        }
        if (ml2.getRemove() != null && ConflictDetectionHelper.areConflicting(il, ml2.getRemove())) {
            result.add(ml2.getRemove());
        }
        Iterator it = ml2.getInsert().iterator();
        while (it.hasNext()) {
            InsertLink il2 = (InsertLink)it.next();
            if (!ConflictDetectionHelper.areConflicting(il, il2) || ConflictDetectionHelper.areEquivalent(il, il2)) continue;
            result.add(il2);
        }
        return result;
    }

    public static Collection getOrderConflictWithRemoveLink(DeltaQuery q, RemoveLink rl) {
        Vector<InsertLink> result = new Vector<InsertLink>();
        ModifyLink ml1 = (ModifyLink)rl.eContainer();
        if (!ml1.getProperty().isOrdered()) {
            return result;
        }
        NodeLevelSubDelta mod1 = (NodeLevelSubDelta)ml1.eContainer();
        ModifyLink ml2 = q.getModifyLink(mod1.getId(), (EReference)ml1.getProperty());
        if (ml2 == null) {
            return result;
        }
        Iterator it = ml2.getInsert().iterator();
        while (it.hasNext()) {
            InsertLink il = (InsertLink)it.next();
            if (!ConflictDetectionHelper.areConflicting(il, rl)) continue;
            result.add(il);
        }
        return result;
    }

    static boolean areConflicting(ModifyLinkElement il1, ModifyLinkElement il2) {
        Vector c = new Vector(il1.getRef());
        c.retainAll((Collection<?>)il2.getRef());
        return !c.isEmpty();
    }

    static boolean areEquivalent(InsertLink e1, InsertLink e2) {
        if (MergeHelper.areDiffrent(e1.getPosAfter(), e2.getPosAfter())) {
            return false;
        }
        return e1.getRef().equals((Object)e2.getRef());
    }

    public static Conflict detectDanglingLink(DeltaQuery q, Delete delete) {
        Collection col = ConflictDetectionHelper.getDanglingInsertLink(q, delete);
        if (col.isEmpty()) {
            return null;
        }
        Conflict conf = fac.createConflict();
        conf.setType(ConflictDetection.DANGLING_LINK);
        if (DeltaQuery.isLocalSubDelta(delete)) {
            conf.getLocal().add((Object)delete);
            conf.getRemote().addAll(col);
        } else {
            conf.getLocal().addAll(col);
            conf.getRemote().add((Object)delete);
        }
        return conf;
    }

    public static Collection getDanglingInsertLink(DeltaQuery q, Delete delete) {
        Vector result = new Vector();
        result.addAll(q.getInsertLinks(delete.getId()));
        result.addAll(q.getOppositeInsertLinks(delete.getId()));
        return result;
    }

    public static Conflict checkMultiplicity(String id, EObject o, EReference r, DeltaQuery localQuery, DeltaQuery remoteQuery) {
        if (MergeHelper.isMainReference(r)) {
            return ConflictDetectionHelper.checkMultiplicityAtMainEnd(id, o, r, localQuery, remoteQuery);
        }
        return ConflictDetectionHelper.checkMultiplicityAtOppositeEnd(id, o, r, localQuery, remoteQuery);
    }

    private static Conflict checkMultiplicityAtMainEnd(String id, EObject o, EReference r, DeltaQuery localQuery, DeltaQuery remoteQuery) {
        Vector inserts = new Vector();
        inserts.addAll(localQuery.getInsertLinks(id, r));
        inserts.addAll(remoteQuery.getInsertLinks(id, r));
        Vector removes = new Vector();
        removes.addAll(localQuery.getRemoveLinks(id, r));
        removes.addAll(remoteQuery.getRemoveLinks(id, r));
        Vector deletes = new Vector();
        Set ids = ConflictDetectionHelper.getReferenceValue(o, r);
        deletes.addAll(localQuery.getDeletes(ids));
        deletes.addAll(remoteQuery.getDeletes(ids));
        if (inserts.isEmpty() && removes.isEmpty() && deletes.isEmpty()) {
            return null;
        }
        Iterator it = inserts.iterator();
        while (it.hasNext()) {
            InsertLink il = (InsertLink)it.next();
            ids.addAll(il.getRef());
        }
        it = removes.iterator();
        while (it.hasNext()) {
            RemoveLink rl = (RemoveLink)it.next();
            ids.removeAll((Collection<?>)rl.getRef());
        }
        it = deletes.iterator();
        while (it.hasNext()) {
            Delete d = (Delete)it.next();
            ids.remove(d.getId());
        }
        return ConflictDetectionHelper.createMultiplicityConflict(id, o, r, ids, inserts, removes, deletes);
    }

    private static Conflict checkMultiplicityAtOppositeEnd(String id, EObject o, EReference r, DeltaQuery localQuery, DeltaQuery remoteQuery) {
        NodeLevelSubDelta modify;
        EReference op = r.getEOpposite();
        Vector inserts = new Vector(localQuery.getOppositeInsertLinks(id, op));
        inserts.addAll(remoteQuery.getOppositeInsertLinks(id, op));
        Vector removes = new Vector(localQuery.getOppositeRemoveLinks(id, op));
        removes.addAll(remoteQuery.getOppositeRemoveLinks(id, op));
        Vector deletes = new Vector();
        Set ids = ConflictDetectionHelper.getReferenceValue(o, r);
        deletes.addAll(localQuery.getDeletes(ids));
        deletes.addAll(remoteQuery.getDeletes(ids));
        if (inserts.isEmpty() && removes.isEmpty() && deletes.isEmpty()) {
            return null;
        }
        Iterator it = inserts.iterator();
        while (it.hasNext()) {
            InsertLink il = (InsertLink)it.next();
            modify = (NodeLevelSubDelta)il.eContainer().eContainer();
            ids.add(modify.getId());
        }
        it = removes.iterator();
        while (it.hasNext()) {
            RemoveLink rl = (RemoveLink)it.next();
            modify = (NodeLevelSubDelta)rl.eContainer().eContainer();
            ids.remove(modify.getId());
        }
        it = deletes.iterator();
        while (it.hasNext()) {
            Delete d = (Delete)it.next();
            ids.remove(d.getId());
        }
        return ConflictDetectionHelper.createMultiplicityConflict(id, o, r, ids, inserts, removes, deletes);
    }

    private static Conflict createMultiplicityConflict(String id, EObject o, EReference r, Set resultReferenceValue, Collection inserts, Collection removes, Collection deletes) {
        if (!ConflictDetectionHelper.isMultiplicityViolated(r, resultReferenceValue)) {
            return null;
        }
        Conflict conf = fac.createConflict();
        conf.setType(ConflictDetection.MUL_CONFLICT);
        conf.setDetail(String.valueOf(SimpleModelLabelProvider.getObjectTypeAndNameOrId(o, id)) + " " + r.getName() + " value=" + resultReferenceValue);
        Vector subdeltas = new Vector();
        subdeltas.addAll(deletes);
        subdeltas.addAll(removes);
        subdeltas.addAll(inserts);
        Iterator it = subdeltas.iterator();
        while (it.hasNext()) {
            SubDelta elem = (SubDelta)it.next();
            if (DeltaQuery.isLocalSubDelta(elem)) {
                conf.getLocal().add((Object)elem);
                continue;
            }
            conf.getRemote().add((Object)elem);
        }
        return conf;
    }

    public static Set getReferenceValue(EObject o, EReference r) {
        if (o == null) {
            return new HashSet();
        }
        Object v = o.eGet((EStructuralFeature)r);
        HashSet<String> ids = null;
        if (v instanceof Collection) {
            return new HashSet(MergeHelper.getIDList((Collection)v));
        }
        ids = new HashSet<String>();
        if (v != null) {
            ids.add(MergeHelper.getURIFragment((EObject)v));
        }
        return ids;
    }

    public static boolean isMultiplicityViolated(EReference r, Set ids) {
        int s = ids.size();
        if (s < r.getLowerBound()) {
            return true;
        }
        return r.getUpperBound() > 0 && s > r.getUpperBound();
    }

    public static boolean needMultiplicityCheck(EReference r) {
        if (r.getLowerBound() != 0) {
            return true;
        }
        return r.getUpperBound() != -1;
    }

    public static void changeConflictingIDs(MergeData mergeData, DeltaQuery localQuery, DeltaQuery remoteQuery) {
        Collection c1 = localQuery.getCreatedNodeIDs();
        Collection c2 = remoteQuery.getCreatedNodeIDs();
        Vector redundant = new Vector(c1);
        redundant.retainAll(c2);
        HashSet<String> idSet = new HashSet<String>(mergeData.getRemoteVariant().getIdTable().getIdSet());
        idSet.addAll(mergeData.getLocalVariant().getIdTable().getIdSet());
        Iterator it = redundant.iterator();
        while (it.hasNext()) {
            String oldID = (String)it.next();
            String newID = mergeData.getLocalVariant().getIdTable().changeId(oldID, idSet);
            idSet.add(newID);
            logger.debug((Object)("change ID " + oldID + "->" + newID));
            localQuery.changeID(oldID, newID);
        }
    }
}

