/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.UUIDXMIResourceFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResourceFactory;
import org.eclipse.mddi.modelbus.description.impl.DescriptionPackageImpl;

public class ModelBusResourceSet
extends ResourceSetImpl {
    static GlobalResourceRegistry globalResourceRegistry = new GlobalResourceRegistry();
    public static final URI MB_DEFAULT_RES_URI = URI.createURI((String)"default_resource.modelbus");
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        Map m = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        m.put("*", new UUIDXMIResourceFactory());
        MBXmiResourceFactory.init();
        try {
            EcorePackage p = EcorePackageImpl.init();
            Resource r = p.eResource();
            logger.debug((Object)("Ecore model in Resource " + r));
            logger.debug((Object)("Ecore model in Resource " + r.getResourceSet()));
            ModelBusResourceSet.getGlobalResourceRegistry().registerResource(r.getURI(), r);
        }
        catch (Exception e) {
            logger.error((Object)"cannot bind Ecore model to GlobalRegistry", (Throwable)e);
        }
        DescriptionPackageImpl.init();
        LoggerConfigurator.configure();
    }

    public static void init() {
    }

    public static GlobalResourceRegistry getGlobalResourceRegistry() {
        return globalResourceRegistry;
    }

    public static void registerEPackages(Resource r) {
        Iterator it = r.getContents().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof EPackage)) continue;
            ModelBusResourceSet.registerEPackage((EPackage)o);
        }
    }

    public static void registerEPackage(EPackage p) {
        EPackage registered;
        String uri = p.getNsURI();
        if (uri == null || "".equals(uri)) {
            EPackage superp = p.getESuperPackage();
            uri = superp == null ? "http://model/" + p.getName() : String.valueOf(superp.getNsURI()) + "/" + p.getName();
            p.setNsURI(uri);
        }
        if ((registered = EPackage.Registry.INSTANCE.getEPackage(p.getNsURI())) != null && registered != p) {
            logger.warn((Object)("The EPackage for NS URI " + p.getNsURI() + " changed: " + registered + " -> " + p));
        }
        EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
        Iterator it = p.getESubpackages().iterator();
        while (it.hasNext()) {
            EPackage subp = (EPackage)it.next();
            ModelBusResourceSet.registerEPackage(subp);
        }
    }

    public static boolean isRegistered(EPackage p) {
        return EPackage.Registry.INSTANCE.containsValue((Object)p);
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        EPackage ePackage = this.getPackageRegistry().getEPackage(uri.toString());
        if (ePackage != null) {
            return ePackage.eResource();
        }
        Resource r = globalResourceRegistry.getResource(uri);
        return r;
    }

    public Resource createResource(URI uri) {
        Resource result = globalResourceRegistry.getResource(uri);
        if (result != null) {
            return result;
        }
        result = super.createResource(uri);
        if (result == null) {
            return null;
        }
        if (GlobalResourceRegistry.hasGlobalURIScheme(uri)) {
            try {
                globalResourceRegistry.registerResource(uri, result);
            }
            catch (GlobalResourceRegistry.GlobalResourceException e) {
                logger.error((Object)"createResource", (Throwable)e);
            }
        }
        return result;
    }
}

