/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.asynchronous;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.test.asynchronous.ConsumerAsyncTest;
import org.eclipse.mddi.modelbus.adapter.test.asynchronous.SortModelingServiceImpl;
import org.eclipse.mddi.modelbus.adapter.test.framework.ProviderTest;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;

public class AsyncLocalProviderAndConsumer {
    ProviderTest test;
    Properties prop;
    AdapterStub adapter = null;
    private static Logger logger;
    public static boolean isStarted;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.asynchronous.AsyncProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        isStarted = false;
    }

    public AsyncLocalProviderAndConsumer(Properties p) {
        LoggerConfigurator.configure();
        this.prop = p;
    }

    public void runTest() throws Exception {
        this.providerPart();
        logger.info((Object)"Provider part ready");
        Thread.sleep(3000L);
        logger.info((Object)"Launching local consummation");
        this.consumerPart();
        this.undeployTest();
    }

    private void providerPart() throws Exception {
        this.adapter = new AdapterStubImpl(this.prop);
        SortModelingServiceImpl provider = new SortModelingServiceImpl();
        this.adapter.getToolStub().setProvider((GenericProvider)provider);
        this.adapter.deploy();
    }

    private void consumerPart() throws Exception {
        AdapterStubImpl adapter = null;
        if (adapter == null) {
            adapter = new AdapterStubImpl(this.prop);
        }
        Object[] inputs = new Object[]{"436"};
        ConsumerAsyncTest test = new ConsumerAsyncTest((AdapterStub)adapter, "sort", inputs);
        logger.info((Object)"Starting asynchronous consommation");
        String conId = test.consumeAsync();
        logger.info((Object)("Asynchronous consommation launched with identifier " + conId));
        while (!test.isResultReady(conId)) {
            logger.info((Object)"result not ready");
            Thread.sleep(500L);
        }
        logger.info((Object)"result ready");
        Object[] result = test.getResult(conId);
        logger.info((Object)(" result : " + result[0] + "\n The test has successfully finished."));
    }

    public void undeployTest() throws Exception {
        this.adapter.undeploy();
    }

    public static void main(String[] args) {
        if (isStarted) {
            return;
        }
        String registry_loc = args.length > 0 ? args[0] : BasicRegistry.getUrl();
        String desc_file = args.length > 1 ? args[1] : "./src/org/eclipse/mddi/modelbus/adapter/test/asynchronous/sort.description";
        try {
            Properties p = new Properties();
            p.put("registry_location", registry_loc);
            p.put("tool_desc_file", desc_file);
            AsyncLocalProviderAndConsumer testSample = new AsyncLocalProviderAndConsumer(p);
            testSample.runTest();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

