/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.registry;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager;

public class BasicRegistry
implements EndPoint {
    public static final String REL_PATH = "modelwareRegistry";
    private static Logger logger;
    public static int port;
    private static HashMap tools;
    public static boolean isStarted;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        port = 8082;
        tools = new HashMap();
        isStarted = false;
    }

    public static String getUrl() {
        return "http://localhost:" + port + "/" + "modelbus" + "/" + REL_PATH;
    }

    public static void start(int _port) throws Exception {
        port = _port;
        BasicRegistry.start();
        logger.info((Object)("Registry is running at:" + BasicRegistry.getUrl()));
    }

    public static void start() throws Exception {
        LoggerConfigurator.configure();
        if (isStarted) {
            return;
        }
        isStarted = true;
        BasicRegistry r = new BasicRegistry();
        ServerManager.getInstance().getServer(port);
        EndPointManagerImpl.getInstance().putEndPoint(REL_PATH, (EndPoint)r);
        logger.info((Object)("Registry is running on:" + BasicRegistry.getUrl()));
    }

    public static void stop() {
        EndPointManagerImpl.getInstance().removeEndPoint(REL_PATH);
        isStarted = false;
    }

    public void execute(String urlPath, SOAPEnvelope request, SOAPEnvelope response) throws SOAPException {
        SOAPBody requestbody = request.getBody();
        logger.debug((Object)("Request: " + request));
        SOAPElement reqTopElem = SoapUtil.getFirstChild((SOAPElement)requestbody);
        String serviceName = reqTopElem.getLocalName();
        SOAPBody responsebody = response.getBody();
        responsebody.addNamespaceDeclaration("reg", "http://impl.registry.modelware");
        if (serviceName.equalsIgnoreCase("ToolInstance")) {
            String value = reqTopElem.getValue();
            String token = new Integer(reqTopElem.hashCode()).toString();
            tools.put(token, value);
            logger.debug((Object)value);
            SOAPElement el = responsebody.addChildElement("registerToolReturn", "registerToolReponse");
            el.addTextNode(token);
        } else if (serviceName.equalsIgnoreCase("lookupAllModelingServices") || serviceName.equalsIgnoreCase("lookupModelingServicesByName") || serviceName.equalsIgnoreCase("lookupAllModelingServiceInterfaces") || serviceName.equalsIgnoreCase("modelingServiceInterfaceName")) {
            SOAPElement paramElem = responsebody.addChildElement("lookupAllModelingServiceInterfacesReturn");
            Iterator it = tools.values().iterator();
            while (it.hasNext()) {
                SOAPElement itemElem = paramElem.addChildElement("item");
                itemElem.addTextNode((String)it.next());
            }
        } else if (serviceName.equalsIgnoreCase("ToolToken") || serviceName.equalsIgnoreCase("deregisterTool")) {
            String token = reqTopElem.getValue();
            logger.info((Object)("Tool Deregistring is called for token:" + token));
            tools.remove(token);
        } else {
            SOAPFault f = responsebody.addFault();
            f.setFaultString("Registry: unsupported service " + serviceName);
            logger.error((Object)("Registry: unsupported service " + serviceName));
        }
        logger.debug((Object)("Response: " + response));
    }

    public static void main(String[] args) {
        LoggerConfigurator.configure();
        if (args != null && args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        try {
            BasicRegistry.start();
        }
        catch (Exception e) {
            logger.error((Object)"Registry was not started:", (Throwable)e);
            System.exit(1);
        }
    }
}

