/*
 * $RCSfile: Provider.java,v $
 * $Date: 2006/03/13 16:18:05 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * Provider.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:18:05 $
 */
package org.eclipse.mddi.modelbus.adapter.test.anno;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;

import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.impl.UML2PackageImpl;



public class Provider {

    public static String REG = BasicRegistry.getUrl();    

    
    
    
    public static void main(String[] args) throws Exception {
        UML2PackageImpl.init();
        
        
        //start registry
        BasicRegistry.start();
        
        Properties p;
        p = new Properties();
        p.put(AdapterStub.PROP_REGISTRY_LOCATION, REG);
        p.put(AdapterStub.PROP_TOOL_DESC_FILE, "./src/org/eclipse/mddi/modelbus/adapter/test/anno/inoutModelService.description");
        
        AdapterStub stub = new AdapterStubImpl(p);       
        stub.getToolStub().setProvider(new MyTool());
        stub.deploy();
    }    
    
    
    static class MyTool implements GenericProvider {
        public Object[] execute(String serviceName, Object[] parameterValues) throws SessionNeeded, ModelingServiceError {

            Collection model = (Collection) parameterValues[0];
            try {
                showResult(model);
            } catch (IOException e) {
                e.printStackTrace();
            }
            updateModel(model);
            Object[] result = {  model };
            return result;
        }        
    }
    
    static void showResult(Collection model) throws IOException {
        System.out.println("Result:");
        System.out.println(Emf2XmiConversion.convertToString(model) );
    }    
    
    
    static EcoreFactory ef = EcorePackageImpl.init().getEcoreFactory();
    
    
    static void updateModel(Collection model) {
        Package p = (Package) model.iterator().next();
        int i =0;
        for(Iterator it = p.getOwnedElements().iterator(); it.hasNext();) {
           NamedElement e = (NamedElement) it.next();
           EAnnotation anno = ef.createEAnnotation();
           anno.setSource("provider:annotation" +i +"=" +i );
           e.getEAnnotations().add(anno);
           i++;
        } 
        
    }
}
