/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.adapter.test.asynchronous;

import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;

/**
 * Example of using Adapter to consume Modeling Services of other tools.
 * The "createNewClass" service is invoked for adding a new class to a model.
 * The new classes are named "class1", "class2", "class3" ...
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh, Nicolas Garandeau (LIP6)
 *  
 */
public class AsyncConsumer {


    AdapterStub adapter = null;
    ConsumerAsyncTest test1;
    Collection model = new Vector(); // model to be used as input. initially empty
    int count = 1;
    
    private static Logger logger =Logger.getLogger(AsyncConsumer.class);
    
    Properties prop;
    
    public AsyncConsumer(Properties p) {
        prop = p;
        LoggerConfigurator.configure();
    }
    
    
    public void runTest() throws Exception {

        if (adapter == null) {

            adapter = new AdapterStubImpl(prop);

        }

        Object[] inputs = new Object[1];

        inputs[0] = "436";

         test1 = new ConsumerAsyncTest(adapter, "sort", inputs);

       
        
         
        logger.info("Starting asynchronous consommation"); 
         
        String conId = test1.consumeAsync();
        
        logger.info("Asynchronous consommation launched with identifier "+conId); 
        
        
        
        while(!test1.isResultReady(conId)){
        	logger.info("result not ready");
        	Thread.sleep(500);
        }
        
        logger.info("result ready");
 
        
        Object[] result = test1.getResult(conId);
        
        logger.info(" result : "+result[0]);

       
    }
    
    public String getModleString() {
        return test1.getString(model);
    }

    /**
     * Invokes createNewClass service 2 times.
     * Display the result of each invocation in the standard output.
     * 
     * @param args
     */
    public static void main(String args[]) {
    	
    	String registry_loc = BasicRegistry.getUrl();
    	
    	Properties p = new Properties();
    	
    	logger.info("Registry location is:"+registry_loc);
    	
    	try {
    		
    		p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);            
    		
    		AsyncConsumer testSample = new AsyncConsumer(p);
    		
    		testSample.runTest();
    		
    		
    		
    		
    	} catch(ModelingServiceError e) {
    		ModelingServiceError err = (ModelingServiceError) e;
    		logger.error("ModelingServiceError: " + err.getName());
    	} catch (Exception e) {
    		e.printStackTrace();
    	}


    }


}