
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * AsyncSessionConsumer.java Add description 
 * 
 * @author Andrey Sadovykh, Nicolas GARANDEAU (LIP6)
 */
package org.eclipse.mddi.modelbus.adapter.test.asynchronous;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;



public class AsyncSessionConsumer {
    public static final String ADD_CLASS = "SampleSessionTool.interface1.addNewClass";

    public static final String OPEN_PACK = "SampleSessionTool.interface1.openPackage";





    private static Logger logger = Logger
            .getLogger(AsyncSessionConsumer.class);



    public static String modelToString(Collection model) {
        String result = new String();
        try {
            result = Emf2XmiConversion.convertToString(model);
            return result + "\n Test has successfully finished.";
        } catch (IOException e) {
            return "ERROR";
        }

    }

    public static void addClass(String className,Collection model, String sessionId,AdapterStub adapter)
            throws Exception {
    	
    	
        
    	Object[] inputs = new Object[2];
        inputs[0] = className;
        inputs[1] = model;

        ConsumerAsyncTest test = new ConsumerAsyncTest(adapter,ADD_CLASS,inputs);
      
        String connexionId = test.consumeAsync(sessionId);
   
        
        while(!test.isResultReady(connexionId)){
           	logger.info("result not ready");
           	Thread.sleep(1);
           }
           logger.info("result ready");
           Object[] outputs = test.getResult(connexionId);
            

        
        for (int i = 0; i < outputs.length; i++) {
			Object object = outputs[i];
			logger.info(" outputs["+i+"] = "+object);
		}
        

        
        model = (Collection) outputs[0];
    }


    public static void main(String[] args) {

    	  Collection model = new Vector();
    	
        String registry_loc;
        if (args.length > 0) {
            registry_loc = args[0];
        } else {
            registry_loc = BasicRegistry.getUrl();
        }

        logger.info("Registry location is:" + registry_loc);

        try {
        	  
        	
            Properties p = new Properties();
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);

   
            AdapterStub adapter = new AdapterStubImpl(p);
 
            Object[] inputs = new Object[] { "Pack2" };
            
           ConsumerAsyncTest testAddClass = new ConsumerAsyncTest(adapter,ADD_CLASS,inputs);
           ConsumerAsyncTest testOpenPack = new ConsumerAsyncTest(adapter,OPEN_PACK,inputs);
           
           String sessionId = testAddClass.openSession();
           
           String connexionId = testOpenPack.consumeAsync(sessionId);
           while(!testOpenPack.isResultReady(connexionId)){
           	logger.info("result not ready");
           	Thread.sleep(1);
           }
           logger.info("result ready");
           Object[] outputs = testOpenPack.getResult(connexionId);
         
            for (int i = 0; i < outputs.length; i++) {
    			Object object = outputs[i];
    			logger.info(" outputs["+i+"] = "+object);
    		}
            
          
            addClass("class A-1",model, sessionId,adapter);


            testAddClass.closeSession(sessionId);

            logger.info("Result:" + modelToString(model));

	
            

            
        } catch (Exception e) {
            e.printStackTrace();
        }
        

    }

}
