/*
 * $RCSfile: PrintStreamRedirector.java,v $
 * $Date: 2006/03/13 16:18:07 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * PrintStreamRedirector.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:18:07 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.test.plugin;

import java.io.PrintStream;

import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/**
 * Adapter for piping PrintStream output to a MessageConsole.
 * <br>Partial implementation but enough for JUnit text output.
 */
class PrintStreamRedirector extends PrintStream {
    
    private final MessageConsoleStream _output;


    /**
     * @param out
     */
    PrintStreamRedirector( MessageConsole console ) {
        super( System.out );
        //assert console != null;
        _output = console.newMessageStream();
    }


    /* (non-Javadoc)
     * @see java.io.PrintStream#print(java.lang.String)
     */
    public void print(String s) {
        _output.print( s );
    }
    
    /* (non-Javadoc)
     * @see java.io.PrintStream#println()
     */
    public void println() {
        _output.println();
    }
    
    /* (non-Javadoc)
     * @see java.io.PrintStream#println(java.lang.String)
     */
    public void println(String x) {
        super.println(x);
        _output.println();
    }
}
