/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.adapter.test.plugin;

import java.util.Properties;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.test.plugin.ui.ConsoleView;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.test.sample.ProviderTestSample;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * Performs similar actions to the method ConsumerTestSample.main().
 * See the method run() in this class.
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 */
public class ProviderTestAction implements IWorkbenchWindowActionDelegate {
	private IWorkbenchWindow window;
    
    private static Logger logger = Logger.getLogger(ProviderTestAction.class);

	private static boolean deployed = false; 
	
	ProviderTestSample testSample = null;
	/**
	 * The constructor.
	 */
	public ProviderTestAction() {
        LoggerConfigurator.configure();
	}

	/**
	 * Performs similar actions to the method ProviderTestSample.main
	 * 
	 */
	public void run(IAction action) {
        String registry_loc;
        try {
    	    if(deployed)  {
                logger.debug("Provider tool already deployed.");
                ConsoleView.displayMessage("Provider tool already deployed. \n\n");   
                logger.debug("Undeploying Provider...");
                ConsoleView.displayMessage("Undeploying Provider... \n\n");
                testSample.undeployTest();
                deployed = false; 
                return;
    	    }

            Properties p = new Properties();
            if (SetRegistryAction.getRegistryURL()!=null){
                registry_loc=SetRegistryAction.getRegistryURL();            
            }else {
                registry_loc= BasicRegistry.getUrl();
            }
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);
            String path = AdapterTestPlugin.getFilePath("sample.description");
            p.put(AdapterStub.PROP_TOOL_DESC_FILE , path);
            
    	    testSample = new ProviderTestSample(p);
            testSample.runTest();
            deployed = true;            
  	        ConsoleView.displayMessage("ProviderTestSample. Provider tool deployed successfully. \n\n");
            logger.info("ProviderTestSample. Provider tool deployed successfully.");
   
                      
        } catch (Exception e) {
            ConsoleView.displayMessage(e);
        }
	}

	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
        

	}
}