/*
 * $RCSfile: ProfileSupportedProviderTool.java,v $
 * $Date: 2006/04/12 15:33:04 $
 * $Revision: 1.3 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ProfileReader.java Add description 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.3 $ $Date: 2006/04/12 15:33:04 $
 * @see Add references
 */
package org.eclipse.mddi.modelbus.adapter.test.profile;

import java.util.Collection;
import java.util.Properties;

import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Profile;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.Uml2ModelUtil;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;


/**
 * This test checks that a UML model can be transmitted as a service parameter.
 * The profile must be registerred at the service side prior to service invocation.
 * 
 * The profile will NOT be transmitted with the model but the links between the model and the profile
 * can be established upon model reception.
 * 
 * @author P. Sriplakich
 * 
 *  
 */
public class ProfileSupportedProviderTool {
    
    static String umlResourceURI = "jar:file:/D:/eclipse3.1.1/plugins/org.eclipse.uml2.resources_1.1.0.jar!/";

    public static void main(String[] args) throws Exception {
        if(args.length>0) {
            umlResourceURI = args[0]; 
            System.out.println("Using resource " +umlResourceURI);
        }
        Uml2ModelUtil.init(URI.createURI(umlResourceURI));          
        deployAdapter();
        System.out.println("...... Ready");        
    }
    
    
    public static String REG = BasicRegistry.getUrl();   

    static String[] testcase = ProfileSupportedConsumerTool.testcase;
    
    static void startRegistry(){
        try {
            BasicRegistry.start(); 
        }catch (Exception e){
            
        }
       
    }
    
    static void deployAdapter() throws Exception {
        
        Profile prof = Uml2ModelUtil.registerProfile( URI.createFileURI(testcase[0]) );
        // if the profile is loaded, use Uml2ModelUtil.registerProfile(prof);

        //startRegistry();
        
        Properties p;
        p = new Properties();
        p.put(AdapterStub.PROP_REGISTRY_LOCATION, REG);
        p.put(AdapterStub.PROP_TOOL_DESC_FILE, 
                "src/org/eclipse/mddi/modelbus/adapter/test/profile/inoutModelService.description");
        //p.put(AdapterStub.PROP_PROVIDER_URL, "http://localhost:8081/axis/tool1" );
        
        AdapterStub stub = new AdapterStubImpl(p);       
        stub.getToolStub().setProvider(new ServiceInvocationImpl());
        stub.deploy();      
        
    }
    
    static class ServiceInvocationImpl implements GenericProvider {

        /**
         * Receive a UML model with profile.<br> 
         * Examine this model.  <br> 
         * Modify the UML package name.<br> 
         * Return the same model back.<br> 
         * 
         * @see org.eclipse.mddi.modelbus.tool.GenericProvider#execute(java.lang.String,
         *      java.lang.Object[])
         */
        public Object[] execute(String serviceName, Object[] parameterValues) throws SessionNeeded, ModelingServiceError {
            System.out.println("......... executing the service");
            Collection model = (Collection) parameterValues[0];
            // model contains one top element (Package)
            Model umlModel = (Model) model.iterator().next();
            umlModel.setName( umlModel.getName() +"_");
            ProfileSupportedTool.examineProfiledModel(umlModel);
            return parameterValues;
        }
    }



}