/*
 * $RCSfile: ProfileSupportedTool.java,v $
 * $Date: 2006/03/13 16:18:07 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ProfileSupportedTool.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:18:07 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.test.profile;

import java.util.Iterator;

import org.eclipse.uml2.Model;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Stereotype;

public class ProfileSupportedTool {

    public static void examineProfiledModel(Model umlModel) {
        // show that the model is correctly linked to profile
        for (Iterator it = umlModel.getAllAppliedProfiles().iterator(); it
                .hasNext();) {
            Profile prof1 = (Profile) it.next();
            System.out
                    .println("This model is based on " + prof1);
        }
        // allshow content
        // try {
        // umlModel.eResource().save(System.out, null);
        // } catch(IOException e) {
        // e.printStackTrace();
        // }
        // show stereotype values
        for (Iterator it = umlModel.eAllContents(); it.hasNext();) {
            Object o = it.next();
            if (o instanceof NamedElement) {
                NamedElement ne = (NamedElement) o;
                for (Iterator it2 = ne.getAppliedStereotypes().iterator(); it2
                        .hasNext();) {
                    Stereotype s = (Stereotype) it2.next();
                    for (Iterator it3 = s.getOwnedAttributes().iterator(); it3
                            .hasNext();) {
                        Property p = (Property) it3.next();
                        ProfileSupportedTool.printStereotypePropertyValue(ne,
                                s, p);
                    }
                }
            }
        }

    }

    public static void printStereotypePropertyValue(NamedElement namedElement,
            Stereotype stereotype, Property property) {
        Object value = null;
        try {
            value = namedElement.getValue(stereotype, property.getName());
        } catch (Exception e) {
            value = "N/A";
        }
        System.out.println("[tag value] element " + namedElement.getName() + " "
                + stereotype.getName() + "." + property.getName() + " = "
                + value);

    }


}
