/*
 * $RCSfile: ProfileSupportedConsumerTool2.java,v $
 * $Date: 2006/05/17 13:08:06 $
 * $Revision: 1.4 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ProfileSupportedConsumerTool.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.4 $ $Date: 2006/05/17 13:08:06 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.test.profile2;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.test.profile.ProfileSupportedTool;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.util.*;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.Uml2ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.DefaultModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.uml2.ProfiledModelSerializer;


/**
 * This test checks that a UML model can be transmitted as a service parameter.
 * 
 * The profile will be transmitted with the model
 * 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 *
 *
 */
public class ProfileSupportedConsumerTool2 {
    
    public static String REG = BasicRegistry.getUrl();
    
    static String umlResourceURI = "jar:file:/D:/eclipse3.1.1/plugins/org.eclipse.uml2.resources_1.1.0.jar!/";
    
    static final int PROFILE_FILE_LOCATION = 0;
    static final int MODEL_FILE_LOCATION = 1;
    static final int PROFILE_URI = 2;
    
    // profile, profiled model, the URI from the profiled model to the profile definition
    public static String[] case1 = {
             "src/org/eclipse/mddi/modelbus/adapter/test/profile/Ecore.profile.uml2"      
            ,"src/org/eclipse/mddi/modelbus/adapter/test/profile/ExtendedPO2_Ecore.uml2"
            ,"Ecore.profile.uml2"
    };
    
    public static String[] case2 = {
        "src/org/eclipse/mddi/modelbus/adapter/test/profile/MyProfile.profile.uml2"        
        ,"src/org/eclipse/mddi/modelbus/adapter/test/profile/MySystem.uml2"
        ,"MyProfile.profile.uml2"    
    };
  
    public static String[] testcase = case1;    
        
    public static void main(String[] args) throws Exception {
        

       
        if(args.length > 1 ) {
            REG = args[0];
            umlResourceURI = args[1];
        }
        
        Uml2ModelUtil.init(URI.createURI(umlResourceURI));         
        
        Properties p;
        p = new Properties();
        p.put(AdapterStub.PROP_REGISTRY_LOCATION, REG);
        AdapterStub stub = new AdapterStubImpl(p);  

        // this serializer enables the profiles to be serialized with models.
        DefaultModelSerializer ser = new ProfiledModelSerializer();
        stub.getTransportManager().setModelSerializer(ser);
        // to specify the resources URI to be serialized or NOT 
        // ser.getIgnoredUriPrefixSet().add("pathmap://myprefix");
        
        GenericConsumer si = stub.getGenericConsumer();
        
        
        ResourceSet rset = new ResourceSetImpl();
        
        // The URI of the profile (this URI will NOT be changed by ModelBus)
        URI profileURI = URI.createURI(testcase[PROFILE_URI]);
        
        Resource r = rset.createResource(profileURI);
        InputStream in = new FileInputStream(testcase[PROFILE_FILE_LOCATION]);
        r.load(in, null);
        in.close();
        Profile profile = (Profile) EcoreUtil.getObjectByType(
                r.getContents(), UML2Package.eINSTANCE.getProfile());
        
        // register the EPackages contained in this profile
        // so that the model to which this profile is applied can be loaded
        // with out error.
        Uml2ModelUtil.registerEcorePackagesOfProfile(profile);
        

        // *** Test that the URI of your profile remains the same ***
        System.out.println("Profile URI = " +profile.eResource().getURI());
        
        
        // load your profiled model. 
        Resource modelResource = rset.createResource(URI.createURI(testcase[MODEL_FILE_LOCATION]));
        modelResource.load(null);
//        modelResource.save(System.out, null);
        
//        System.exit(0);

        System.out.println("......... invoking service");        
        // invoke service
        Object[] inputs = { modelResource.getContents() };
        Object[] outputs = si.consume("inoutModelService", inputs);
        
        System.out.println("......... result");
        Model result = (Model) ((Collection) outputs[0]).iterator().next();
        // show tag values in the model
        
        ProfileSupportedTool.examineProfiledModel(result);

        
    }
}
