/*
 * $RCSfile: NotificationConsumerTest.java,v $
 * $Date: 2006/03/20 13:17:42 $
 * $Revision: 1.4 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * NotificationConsumerTest.java Start that for a tool consume notifications 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.4 $ $Date: 2006/03/20 13:17:42 $
 */
package org.eclipse.mddi.modelbus.adapter.test.sample;

import java.util.Properties;

import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;

public class NotificationConsumerTest {

    public static void main(String[] args) throws DeploymentException {
        
        Properties p = new Properties();
        p.put(AdapterStub.PROP_NOTIF_LOCATION, "http://localhost:8080/axis/services/NotificationBroker");
        p.put(AdapterStub.PROP_NOTIF_TOPICS, "ModelChangeNotification");
        
        AdapterStub adapter = new AdapterStubImpl(p);
        
        // Object that wants to receive notificartions
        SampleNotificationConsumer con = new SampleNotificationConsumer();
        
        adapter.getToolStub().setNotificationConsumer(con);
        
        adapter.deploy();
        
        adapter.undeploy();
    }
}
