/*
 * $RCSfile: CustomSerializer.java,v $
 * $Date: 2006/05/24 15:50:11 $
 * $Revision: 1.5 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * CustomSerializer.java
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.5 $ $Date: 2006/05/24 15:50:11 $
 */
package org.eclipse.mddi.modelbus.adapter.test.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.AbstractBasicModelSerializer;

/**
 * 
 * CustomSerializer implementes a dummy serializer that keeps models in a String
 * format
 *  
 */
public class CustomSerializer extends AbstractBasicModelSerializer {

    public CustomSerializer() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.AbstractBasicModelSerializer#serialize(java.lang.Object,
     *      java.io.OutputStream)
     */
    protected void serialize(Object o, OutputStream xmiStream) {
        String myXMI = (String) o;

        try {
            xmiStream.write(myXMI.getBytes());
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.AbstractBasicModelSerializer#deserialize(java.io.InputStream)
     */
    protected Object deserialize(InputStream xmiStream) {

        try {
            String myXMI;
            int n = xmiStream.available();
            byte buffer[] = new byte[n];
            xmiStream.read(buffer);
            myXMI = new String(buffer);
            return myXMI;
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
        return null;
    }

}
