/*
 * $RCSfile: SeralizerConsumer.java,v $
 * $Date: 2006/05/24 15:50:11 $
 * $Revision: 1.4 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * SeralizerConsumer.java
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.4 $ $Date: 2006/05/24 15:50:11 $
 */
package org.eclipse.mddi.modelbus.adapter.test.serializer;

import java.util.Properties;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;

/**
 * 
 * SeralizerConsumer use model in a String format. It calls ProviderTestSample.
 * 
 */
public class SeralizerConsumer {

    public static Logger logger = Logger.getLogger(SeralizerConsumer.class);
    public static AdapterStub adapter;
    public static final String createNewClass = "testTool.interface1.createNewClass";

    public static GenericConsumer consumer;

    public static String model = "<?xml version=\"1.0\" encoding=\"ASCII\"?>"+
            "<xmi:XMI xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\"/>"; // model in String format

 
    /**
     * main Add description
     * 
     * @param args
     * 
     */

    public static void main(String[] args) {
        String registry_loc;
        if (args.length > 0) {
            registry_loc = args[0];
        } else {
            registry_loc = BasicRegistry.getUrl();
        }

        logger.info("Registry location is:" + registry_loc);

        try {
            Properties p = new Properties();
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);

            adapter = new AdapterStubImpl(p);
            //setting up new serializer
            adapter.setModelSerializer(new CustomSerializer());

            consumer = adapter.getGenericConsumer();

            for (int count = 0; count < 4; count++) {
                String newClassName = "class A" + count;
                logger.info("Create New Class with name:"+newClassName);
                Object[] outputs = consumer.consume(createNewClass, new Object[] { newClassName,model });
                model = (String) outputs[0];
                logger.info("Result Model:" + model);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
