/*
 * $RCSfile: SerializerProvider.java,v $
 * $Date: 2006/05/24 15:50:11 $
 * $Revision: 1.4 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * SerializerProvider.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.4 $ $Date: 2006/05/24 15:50:11 $
 */
package org.eclipse.mddi.modelbus.adapter.test.serializer;

import java.util.Properties;

import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;


public class SerializerProvider {

    public static void main(String[] args) {
        String registry_loc = "http://localhost:8082/modelbus/modelwareRegistry";
        String desc_file = "./sample.description";

        try {
            Properties p = new Properties();
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);
            p.put(AdapterStub.PROP_TOOL_DESC_FILE, desc_file);

            AdapterStub adapter = new AdapterStubImpl(p);
            adapter.setModelSerializer(new CustomSerializer());

            GenericProvider provider = new SerializerModelingService();

            adapter.getToolStub().setProvider(provider);
            adapter.deploy();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
