/**
 * <copyright>
 * </copyright>
 *
 * $Id: AbstractPackage.java,v 1.1 2006/01/24 15:43:02 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.description.abstract_;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.mddi.modelbus.description.abstract_.AbstractFactory
 * @generated
 */
public interface AbstractPackage extends EPackage {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String copyright = "Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.  All rights reserved.This software is published under the terms of the ModelBus Software License in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. A copy of ModelBus Software License is provided with this distribution in doc/LICENSE.txt file.";

    /**
     * The package name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNAME = "abstract";

    /**
     * The package namespace URI.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_URI = "http://modelbus/description/abstract";

    /**
     * The package namespace name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_PREFIX = "abstract";

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    AbstractPackage eINSTANCE = org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl.init();

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ModelingServiceInterfaceImpl <em>Modeling Service Interface</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.ModelingServiceInterfaceImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getModelingServiceInterface()
     * @generated
     */
    int MODELING_SERVICE_INTERFACE = 0;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODELING_SERVICE_INTERFACE__NAME = 0;

    /**
     * The feature id for the '<em><b>Service</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODELING_SERVICE_INTERFACE__SERVICE = 1;

    /**
     * The feature id for the '<em><b>Published Event</b></em>' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODELING_SERVICE_INTERFACE__PUBLISHED_EVENT = 2;

    /**
     * The number of structural features of the the '<em>Modeling Service Interface</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODELING_SERVICE_INTERFACE_FEATURE_COUNT = 3;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ModelingServiceImpl <em>Modeling Service</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.ModelingServiceImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getModelingService()
     * @generated
     */
    int MODELING_SERVICE = 1;

    /**
     * The feature id for the '<em><b>Parameter</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODELING_SERVICE__PARAMETER = 0;

    /**
     * The feature id for the '<em><b>Service Error</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODELING_SERVICE__SERVICE_ERROR = 1;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODELING_SERVICE__NAME = 2;

    /**
     * The number of structural features of the the '<em>Modeling Service</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODELING_SERVICE_FEATURE_COUNT = 3;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ParameterImpl <em>Parameter</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.ParameterImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getParameter()
     * @generated
     */
    int PARAMETER = 2;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER__NAME = 0;

    /**
     * The feature id for the '<em><b>Type</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER__TYPE = 1;

    /**
     * The feature id for the '<em><b>Direction</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER__DIRECTION = 2;

    /**
     * The feature id for the '<em><b>Lower</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER__LOWER = 3;

    /**
     * The feature id for the '<em><b>Upper</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER__UPPER = 4;

    /**
     * The number of structural features of the the '<em>Parameter</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_FEATURE_COUNT = 5;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.TypeImpl <em>Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.TypeImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getType()
     * @generated
     */
    int TYPE = 3;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TYPE__NAME = 0;

    /**
     * The number of structural features of the the '<em>Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TYPE_FEATURE_COUNT = 1;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ModelTypeImpl <em>Model Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.ModelTypeImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getModelType()
     * @generated
     */
    int MODEL_TYPE = 4;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODEL_TYPE__NAME = TYPE__NAME;

    /**
     * The feature id for the '<em><b>Content</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODEL_TYPE__CONTENT = TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Model Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MODEL_TYPE_FEATURE_COUNT = TYPE_FEATURE_COUNT + 1;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.PrimitiveTypeImpl <em>Primitive Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.PrimitiveTypeImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getPrimitiveType()
     * @generated
     */
    int PRIMITIVE_TYPE = 5;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRIMITIVE_TYPE__NAME = TYPE__NAME;

    /**
     * The number of structural features of the the '<em>Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PRIMITIVE_TYPE_FEATURE_COUNT = TYPE_FEATURE_COUNT + 0;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.EnumerationTypeImpl <em>Enumeration Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.EnumerationTypeImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getEnumerationType()
     * @generated
     */
    int ENUMERATION_TYPE = 6;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATION_TYPE__NAME = TYPE__NAME;

    /**
     * The feature id for the '<em><b>Labels</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATION_TYPE__LABELS = TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Enumeration Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENUMERATION_TYPE_FEATURE_COUNT = TYPE_FEATURE_COUNT + 1;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ErrorImpl <em>Error</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.ErrorImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getError()
     * @generated
     */
    int ERROR = 7;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ERROR__NAME = 0;

    /**
     * The feature id for the '<em><b>Type</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ERROR__TYPE = 1;

    /**
     * The feature id for the '<em><b>Lower</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ERROR__LOWER = 2;

    /**
     * The feature id for the '<em><b>Upper</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ERROR__UPPER = 3;

    /**
     * The number of structural features of the the '<em>Error</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ERROR_FEATURE_COUNT = 4;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.MetaclassSpecificationImpl <em>Metaclass Specification</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.MetaclassSpecificationImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getMetaclassSpecification()
     * @generated
     */
    int METACLASS_SPECIFICATION = 8;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int METACLASS_SPECIFICATION__NAME = 0;

    /**
     * The feature id for the '<em><b>Meta Class</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int METACLASS_SPECIFICATION__META_CLASS = 1;

    /**
     * The feature id for the '<em><b>Lower</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int METACLASS_SPECIFICATION__LOWER = 2;

    /**
     * The feature id for the '<em><b>Upper</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int METACLASS_SPECIFICATION__UPPER = 3;

    /**
     * The number of structural features of the the '<em>Metaclass Specification</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int METACLASS_SPECIFICATION_FEATURE_COUNT = 4;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.impl.EventImpl <em>Event</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.EventImpl
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getEvent()
     * @generated
     */
    int EVENT = 9;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EVENT__NAME = 0;

    /**
     * The feature id for the '<em><b>Event Info</b></em>' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EVENT__EVENT_INFO = 1;

    /**
     * The number of structural features of the the '<em>Event</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EVENT_FEATURE_COUNT = 2;

    /**
     * The meta object id for the '{@link org.eclipse.mddi.modelbus.description.abstract_.DirectionKind <em>Direction Kind</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.mddi.modelbus.description.abstract_.DirectionKind
     * @see org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl#getDirectionKind()
     * @generated
     */
    int DIRECTION_KIND = 10;


    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface <em>Modeling Service Interface</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Modeling Service Interface</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface
     * @generated
     */
    EClass getModelingServiceInterface();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface#getName()
     * @see #getModelingServiceInterface()
     * @generated
     */
    EAttribute getModelingServiceInterface_Name();

    /**
     * Returns the meta object for the containment reference list '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface#getService <em>Service</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Service</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface#getService()
     * @see #getModelingServiceInterface()
     * @generated
     */
    EReference getModelingServiceInterface_Service();

    /**
     * Returns the meta object for the reference list '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface#getPublishedEvent <em>Published Event</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Published Event</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface#getPublishedEvent()
     * @see #getModelingServiceInterface()
     * @generated
     */
    EReference getModelingServiceInterface_PublishedEvent();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelingService <em>Modeling Service</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Modeling Service</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelingService
     * @generated
     */
    EClass getModelingService();

    /**
     * Returns the meta object for the containment reference list '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelingService#getParameter <em>Parameter</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Parameter</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelingService#getParameter()
     * @see #getModelingService()
     * @generated
     */
    EReference getModelingService_Parameter();

    /**
     * Returns the meta object for the containment reference list '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelingService#getServiceError <em>Service Error</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Service Error</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelingService#getServiceError()
     * @see #getModelingService()
     * @generated
     */
    EReference getModelingService_ServiceError();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelingService#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelingService#getName()
     * @see #getModelingService()
     * @generated
     */
    EAttribute getModelingService_Name();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.Parameter <em>Parameter</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Parameter</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Parameter
     * @generated
     */
    EClass getParameter();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Parameter#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Parameter#getName()
     * @see #getParameter()
     * @generated
     */
    EAttribute getParameter_Name();

    /**
     * Returns the meta object for the reference '{@link org.eclipse.mddi.modelbus.description.abstract_.Parameter#getType <em>Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Type</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Parameter#getType()
     * @see #getParameter()
     * @generated
     */
    EReference getParameter_Type();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Parameter#getDirection <em>Direction</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Direction</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Parameter#getDirection()
     * @see #getParameter()
     * @generated
     */
    EAttribute getParameter_Direction();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Parameter#getLower <em>Lower</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Lower</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Parameter#getLower()
     * @see #getParameter()
     * @generated
     */
    EAttribute getParameter_Lower();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Parameter#getUpper <em>Upper</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Upper</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Parameter#getUpper()
     * @see #getParameter()
     * @generated
     */
    EAttribute getParameter_Upper();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.Type <em>Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Type</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Type
     * @generated
     */
    EClass getType();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Type#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Type#getName()
     * @see #getType()
     * @generated
     */
    EAttribute getType_Name();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelType <em>Model Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Model Type</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelType
     * @generated
     */
    EClass getModelType();

    /**
     * Returns the meta object for the containment reference list '{@link org.eclipse.mddi.modelbus.description.abstract_.ModelType#getContent <em>Content</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Content</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.ModelType#getContent()
     * @see #getModelType()
     * @generated
     */
    EReference getModelType_Content();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType <em>Primitive Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Primitive Type</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType
     * @generated
     */
    EClass getPrimitiveType();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.EnumerationType <em>Enumeration Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Enumeration Type</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.EnumerationType
     * @generated
     */
    EClass getEnumerationType();

    /**
     * Returns the meta object for the attribute list '{@link org.eclipse.mddi.modelbus.description.abstract_.EnumerationType#getLabels <em>Labels</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute list '<em>Labels</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.EnumerationType#getLabels()
     * @see #getEnumerationType()
     * @generated
     */
    EAttribute getEnumerationType_Labels();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.Error <em>Error</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Error</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error
     * @generated
     */
    EClass getError();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Error#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error#getName()
     * @see #getError()
     * @generated
     */
    EAttribute getError_Name();

    /**
     * Returns the meta object for the reference '{@link org.eclipse.mddi.modelbus.description.abstract_.Error#getType <em>Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Type</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error#getType()
     * @see #getError()
     * @generated
     */
    EReference getError_Type();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Error#getLower <em>Lower</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Lower</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error#getLower()
     * @see #getError()
     * @generated
     */
    EAttribute getError_Lower();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Error#getUpper <em>Upper</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Upper</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error#getUpper()
     * @see #getError()
     * @generated
     */
    EAttribute getError_Upper();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification <em>Metaclass Specification</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Metaclass Specification</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification
     * @generated
     */
    EClass getMetaclassSpecification();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification#getName()
     * @see #getMetaclassSpecification()
     * @generated
     */
    EAttribute getMetaclassSpecification_Name();

    /**
     * Returns the meta object for the reference '{@link org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification#getMetaClass <em>Meta Class</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Meta Class</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification#getMetaClass()
     * @see #getMetaclassSpecification()
     * @generated
     */
    EReference getMetaclassSpecification_MetaClass();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification#getLower <em>Lower</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Lower</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification#getLower()
     * @see #getMetaclassSpecification()
     * @generated
     */
    EAttribute getMetaclassSpecification_Lower();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification#getUpper <em>Upper</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Upper</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification#getUpper()
     * @see #getMetaclassSpecification()
     * @generated
     */
    EAttribute getMetaclassSpecification_Upper();

    /**
     * Returns the meta object for class '{@link org.eclipse.mddi.modelbus.description.abstract_.Event <em>Event</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Event</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Event
     * @generated
     */
    EClass getEvent();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.mddi.modelbus.description.abstract_.Event#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Event#getName()
     * @see #getEvent()
     * @generated
     */
    EAttribute getEvent_Name();

    /**
     * Returns the meta object for the reference list '{@link org.eclipse.mddi.modelbus.description.abstract_.Event#getEventInfo <em>Event Info</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Event Info</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Event#getEventInfo()
     * @see #getEvent()
     * @generated
     */
    EReference getEvent_EventInfo();

    /**
     * Returns the meta object for enum '{@link org.eclipse.mddi.modelbus.description.abstract_.DirectionKind <em>Direction Kind</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for enum '<em>Direction Kind</em>'.
     * @see org.eclipse.mddi.modelbus.description.abstract_.DirectionKind
     * @generated
     */
    EEnum getDirectionKind();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
    AbstractFactory getAbstractFactory();

} //AbstractPackage
