/*
 * $RCSfile: LoggerConfigurator.java,v $
 * $Date: 2006/07/14 08:14:14 $
 * $Revision: 1.5 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * LoggerConfigurator.java
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.5 $ $Date: 2006/07/14 08:14:14 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.TTCCLayout;

public class LoggerConfigurator {

    private static boolean isConfigured=false;
    private static Logger logger=Logger.getLogger("org.eclipse.mddi.modelbus");
    private static Logger root=Logger.getRootLogger();
    
    public LoggerConfigurator() {
    }

    public static void configure(){
        if (!isConfigured) {
            isConfigured=true;
            //BasicConfigurator.configure();
            ConsoleAppender ap = new ConsoleAppender(new TTCCLayout(), 
                    ConsoleAppender.SYSTEM_OUT);
            root.removeAllAppenders();
            root.addAppender(ap);
            root.setLevel(Level.INFO);
            logger.setLevel(Level.DEBUG);
            
            logger.info("Logger configured");
        }
    }
    

}
