package org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync;
/**
 * @author Nicolas Garandeau (lip6)
 * 
 * This class is responsible for registering the result, for knowing if it's ready, and for getting it. 
 *
 */
public class PollObject {
	
	/**
	 *  The boolean isResultReady indicates if the result has been registered in the PollObject
	 */
	private boolean isResultReady;
	
	/**
	 * If the result has been registered, this object contains the result
	 */
	private Object result; 
	
	/**
	 * this constructor fix the resultReady boolean to false
	 *
	 */
	public PollObject(){
		this.isResultReady = false;
		this.result = null;
	}
	
	/**
	 * this method is used to register a result in the poll object
	 * Since the result has been registered, the result is said ready
	 * @param result
	 */
	public void registerResult(Object result){
		this.result = result;
		this.isResultReady = true;
	}
	
	/**
	 * 
	 * @return
	 * returns a boolean saying if the result has been registered or not
	 */
	public boolean isResultReady() {
		return isResultReady;
	}
	
	
	/**
	 * this method is called to get the result form the pollObject
	 * if the result is ready, the result is returned, 
	 * else the ResultNotReadyException is thrown
	 * 
	 */
	public Object getResult() throws ResultNotReadyException {
		if(isResultReady())
			return result;
		else{
			throw new ResultNotReadyException("Result not ready");
		}
	}
	
}
