/*
 * $RCSfile: AbstractConflictHandler.java,v $
 * $Date: 2006/05/17 12:12:13 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ConflictHandlerImpl.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/05/17 12:12:13 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;

import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictResolution;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergeFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergePackageImpl;

public abstract class AbstractConflictHandler extends AdapterImpl implements ConflictHandler {
    
    static MergeFactory fac;
    static {
        fac = MergePackageImpl.init().getMergeFactory();  
    }
    
    public static ConflictResolution getResolution(Conflict conf) {
        Merge m = (Merge) conf.eContainer()
            .eContainer();
        return m.getResolution();
    }    
    
    
    protected MergeData mergeData;
    protected boolean finished = false;   
    
    public void start(MergeData mergeData) {
       this.mergeData = mergeData;
       mergeData.getMergeModel().eAdapters().add(this);
    }
    
    public MergeData getMergeData() {
        return mergeData;
    }
    

    public boolean finished() {
        return finished;
    }
    
    
    public boolean isAdapterForType(Object type) {
      if(!(type instanceof Class)) return false;
      return ((Class)type).isAssignableFrom(this.getClass());
    }    
    
}


