/*
 * $RCSfile: BasicConflictHandler.java,v $
 * $Date: 2006/05/17 12:12:12 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ConflictResolutionEditor.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/05/17 12:12:12 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.BasicConflictResolution;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyExisting;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;

public class BasicConflictHandler extends AbstractConflictHandler {

    // check whether all sub-deltas are canceled
    public static boolean isAllCanceled(List l) {
        if (l.isEmpty()) {
            return true;
        }
        Merge m = DeltaQuery.getMerge((SubDelta) l.get(0));
        if (m == null) {
            return false;
        }
        BasicConflictResolution r = (BasicConflictResolution) m.getResolution();
        if (r == null) {
            return false;
        }
        for (int i = 0; i < l.size(); i++) {
            SubDelta d = (SubDelta) l.get(i);
            if (!BasicConflictHandler.isCanceled(d, r)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isCanceled(SubDelta d, BasicConflictResolution r) {
        if (r == null)
            return false;
        if (r.getCanceledSubDelta().contains(d)) {
            return true;
        }
        return false;
    }

    public static boolean isCanceled(SubDelta d) {
        Merge m = DeltaQuery.getMerge(d);
        if (m == null)
            return false;
        return isCanceled(d, (BasicConflictResolution) m.getResolution());
    }

    public static boolean isAllCanceled(Collection c, BasicConflictResolution r) {
        if (r == null)
            return false;
        if (r.getCanceledSubDelta().containsAll(c)) {
            return true;
        }
        return false;
    }

    public static boolean isAllCanceled(Collection c) {
        if (c.isEmpty())
            return true;
        SubDelta d = (SubDelta) c.iterator().next();
        Merge m = DeltaQuery.getMerge(d);
        if (m == null)
            return false;
        return isAllCanceled(c, (BasicConflictResolution) m.getResolution());
    }

    public static void chooseLocal(Conflict conf) {
        BasicConflictResolution r = (BasicConflictResolution) getResolution(conf);
        r.getCanceledSubDelta().removeAll(conf.getLocal());
        r.getCanceledSubDelta().addAll(conf.getRemote());
    }

    public static void chooseRemote(Conflict conf) {
        BasicConflictResolution r = (BasicConflictResolution) getResolution(conf);
        r.getCanceledSubDelta().removeAll(conf.getRemote());
        r.getCanceledSubDelta().addAll(conf.getLocal());
    }

    public static Delta getNewDelta(Delta old, Collection canceled) {
        Delta d2 = fac.createDelta();
        for (Iterator it = old.getContent().iterator(); it.hasNext();) {
            NodeLevelSubDelta nl = (NodeLevelSubDelta) it.next();
            if (canceled.contains(nl))
                continue;
            NodeLevelSubDelta nl2 = (NodeLevelSubDelta) EcoreUtil.create(nl
                    .eClass());
            nl2.setId(nl.getId());
            if (nl instanceof Create) {
                Create c2 = (Create) nl2;
                c2.setType(((Create) nl).getType());
                d2.getContent().add(nl2);
            }
            if (nl instanceof Delete) {
                d2.getContent().add(nl2);
            }
            for (Iterator it2 = nl.getContent().iterator(); it2.hasNext();) {
                ModifyProp modProp = (ModifyProp) it2.next();
                if (canceled.contains(modProp))
                    continue;
                ModifyProp modProp2 = (ModifyProp) EcoreUtil.create(modProp
                        .eClass());
                modProp2.setProperty(modProp.getProperty());
                if (modProp instanceof ModifyPrimitive) {
                    ((ModifyPrimitive) modProp2)
                            .setValue(((ModifyPrimitive) modProp).getValue());
                    nl2.getContent().add(modProp2);
                } else if (modProp instanceof ModifyLink) {
                    ModifyLink ml = (ModifyLink) modProp;
                    ModifyLink ml2 = (ModifyLink) modProp2;
                    if ((ml.getRemove() != null)
                            && !canceled.contains(ml.getRemove())) {
                        RemoveLink rl2 = fac.createRemoveLink();
                        rl2.getRef().addAll(ml.getRemove().getRef());
                        ml2.setRemove(rl2);
                    }
                    for (Iterator it3 = ml.getInsert().iterator(); it3
                            .hasNext();) {
                        InsertLink il = (InsertLink) it3.next();
                        if (canceled.contains(il))
                            continue;
                        InsertLink il2 = fac.createInsertLink();
                        il2.setPosAfter(il.getPosAfter());
                        il2.getRef().addAll(il.getRef());
                        ml2.getInsert().add(il2);
                    } // end it3
                    if ((ml2.getRemove() != null) || !ml2.getInsert().isEmpty()) {
                        nl2.getContent().add(modProp2);
                    }
                }
            } // end it2
            if ((nl2 instanceof ModifyExisting) && !nl2.getContent().isEmpty()) {
                d2.getContent().add(nl2);
            }
        }
        return d2;
    }

    protected BasicConflictResolution res;

    Delta newLocalDelta;

    Delta newRemoteDelta;

    Collection conflicts;

    public BasicConflictHandler() {

    }

    public void start(MergeData mergeData) {
        super.start(mergeData);
        Merge m = mergeData.getMergeModel();
        if (!(m.getResolution() instanceof BasicConflictResolution)) {
            res = fac.createBasicConflictResolution();
            m.setResolution(res);
        } else {
            res = (BasicConflictResolution) m.getResolution();
        }
    }

    public Collection testFinish() {
        Set canceled = new HashSet(res.getCanceledSubDelta());
        newLocalDelta = getNewDelta(mergeData.getMergeModel().getLocalDelta(),
                canceled);
        newRemoteDelta = getNewDelta(
                mergeData.getMergeModel().getRemoteDelta(), canceled);
        conflicts = ConflictDetection.recheck(newLocalDelta, newRemoteDelta,
                mergeData.getBaseVariant());
        if (conflicts.isEmpty()) {
            finished = true;
        }
        return conflicts;
    }

    public Resource getResult() {
        if (!finished) {
            return null;
        }
        MBXmiResource r = mergeData.getBaseVariant();
        if (r == null) {
            return null;
        }
        DeltaApplication da = new DeltaApplication(r);
        da.apply(newLocalDelta);
        da.apply(newRemoteDelta);
        return r;
    }

}
