/*
 * $RCSfile: ConflictDetection.java,v $
 * $Date: 2006/05/17 12:12:13 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ConflictDetection.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/05/17 12:12:13 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergeFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyExisting;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.SimpleModelLabelProvider;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergePackageImpl;

public class ConflictDetection {

    static MergeFactory fac;
    static {
        fac = MergePackageImpl.init().getMergeFactory();
    }

    static Logger logger = Logger.getLogger("ConflictDetection");

    public static String DELETE_UPDATE = "DeleteUpdate";

    public static String DANGLING_LINK = "DanglingLink";

    public static String CONCURRENT_UPDATE_PRIMITIVE = "ConcurrentUpdatePrimitive";

    // insert-insert or insert-remove
    public static String ORDER_CONFLICT = "OrderConflict";

    public static String MUL_CONFLICT = "MultiplicityConflict";

    /**
     * 
     * detect the Conflicts for the first time. The detected conflicts will be
     * put on the Merge model
     * 
     * @param mergeData
     * 
     * 
     */
    public static void firstCheck(MergeData mergeData) {
        DeltaQuery localQuery = new DeltaQuery(mergeData.getMergeModel()
                .getLocalDelta());
        DeltaQuery remoteQuery = new DeltaQuery(mergeData.getMergeModel()
                .getRemoteDelta());
        ConflictDetectionHelper.changeConflictingIDs(mergeData, localQuery,
                remoteQuery);
        ConflictDetection cd = new ConflictDetection(localQuery, remoteQuery,
                mergeData.getBaseVariant());
        List conflicts = cd.detect();
        ConflictSet conflictSet = fac.createConflictSet();
        conflictSet.getElement().addAll(conflicts);
        mergeData.getMergeModel().setConflict(conflictSet);
    }

    /**
     * 
     * recheck the conflicts again after trying to resolve them. The supplied
     * parameters are deltas that have been modified by the conflict handler
     * (e.g. with some subdelta canceled)
     * 
     * @param local
     * @param remote
     * @param base
     * @return The collection of Conflict instances
     * 
     * 
     */
    public static List recheck(Delta local, Delta remote, MBXmiResource base) {
        DeltaQuery localQuery = new DeltaQuery(local);
        DeltaQuery remoteQuery = new DeltaQuery(remote);
        ConflictDetection cd = new ConflictDetection(localQuery, remoteQuery,
                base);
        return cd.detect();
    }

    MBXmiResource baseVariant;

    DeltaQuery localQuery;

    DeltaQuery remoteQuery;

    List conflicts;

    ConflictDetection(DeltaQuery local, DeltaQuery remote, MBXmiResource base) {
        localQuery = local;
        local.getDelta().setLocal(true);
        remoteQuery = remote;
        remote.getDelta().setLocal(false);
        baseVariant = base;
    }

    List detect() {
        conflicts = new Vector();
        detectDeleteModify();
        detectConcurrentModify();
        detectOrderConflict();
        detectDanglingLink();
        detectMultiplicityViolation();
        return conflicts;
    }

    void detectDeleteModify() {
        detectDeleteModify(localQuery, remoteQuery);
        detectDeleteModify(remoteQuery, localQuery);
    }

    void detectDeleteModify(DeltaQuery deleter, DeltaQuery modifier) {
        for (Iterator it = deleter.getDelta().getContent().iterator(); it
                .hasNext();) {
            Object o = it.next();
            if (o instanceof Delete) {
                Delete delete = (Delete) o;
                Conflict conf = ConflictDetectionHelper.detectDeleteUpdate(
                        modifier, delete);
                if (conf != null) {
                    conflicts.add(conf);
                }
            }
        }
    }

    void detectConcurrentModify() {
        for (Iterator it = localQuery.getDelta().getContent().iterator(); it
                .hasNext();) {
            Object o = it.next();
            if (o instanceof ModifyExisting) {
                ModifyExisting mod = (ModifyExisting) o;
                for (Iterator it2 = mod.getContent().iterator(); it2.hasNext();) {
                    Object o2 = it2.next();
                    if (o2 instanceof ModifyPrimitive) {
                        ModifyPrimitive mp = (ModifyPrimitive) o2;
                        Conflict conf = ConflictDetectionHelper
                                .detectConcurrentUpdatePrimitive(remoteQuery,
                                        mp);
                        if (conf != null) {
                            conflicts.add(conf);
                        }
                    }
                }

            }
        }
    }

    void detectOrderConflict() {
        for (Iterator it = localQuery.getDelta().getContent().iterator(); it
                .hasNext();) {
            Object o = it.next();
            if (o instanceof ModifyExisting) {
                ModifyExisting mod = (ModifyExisting) o;
                for (Iterator it2 = mod.getContent().iterator(); it2.hasNext();) {
                    Object o2 = it2.next();
                    if (o2 instanceof ModifyLink) {
                        ModifyLink ml = (ModifyLink) o2;
                        if (((EReference) ml.getProperty()).isOrdered()) {
                            for (Iterator it3 = ml.getInsert().iterator(); it3
                                    .hasNext();) {
                                InsertLink il = (InsertLink) it3.next();
                                Conflict conf = ConflictDetectionHelper
                                        .detectOrderConflict(remoteQuery, il);
                                if (conf != null) {
                                    conflicts.add(conf);
                                }
                            } // end for it3
                            if (ml.getRemove() != null) {
                                Conflict conf = ConflictDetectionHelper
                                        .detectOrderConflict(remoteQuery, ml
                                                .getRemove());
                                if (conf != null) {
                                    conflicts.add(conf);
                                }
                            }
                        }
                    }
                } // end for it2
            }
        } // end for it1
    }

    void detectDanglingLink() {
        detectDanglingLink(localQuery, remoteQuery, true);
        detectDanglingLink(remoteQuery, localQuery, false);
    }

    void detectDanglingLink(DeltaQuery deleter, DeltaQuery inserter,
            boolean local_remote) {
        for (Iterator it = deleter.getDelta().getContent().iterator(); it
                .hasNext();) {
            Object o = it.next();
            if (o instanceof Delete) {
                Delete delete = (Delete) o;
                Conflict conf = ConflictDetectionHelper.detectDanglingLink(
                        inserter, delete);
                if (conf != null) {
                    conflicts.add(conf);
                }
            }
        }
    }

    void detectMultiplicityViolation() {
        Collection deletedNodeIDs = new HashSet(localQuery.getDeletedNodeIDs());
        deletedNodeIDs.addAll(remoteQuery.getDeletes());
        for (Iterator it = baseVariant.getAllContents(); it.hasNext();) {
            EObject o = (EObject) it.next();
            String id = baseVariant.getURIFragment(o);
            logger.debug("check multiplicity of "
                    + SimpleModelLabelProvider.getObjectTypeAndName(o));
            if (!deletedNodeIDs.contains(id)) {
                detectMultiplicityViolation(id, o, o.eClass());
            }
        }
        for (Iterator it = localQuery.getDelta().getContent().iterator(); it
                .hasNext();) {
            NodeLevelSubDelta sub = (NodeLevelSubDelta) it.next();
            if (sub instanceof Create) {
                Create c = (Create) sub;
                logger
                        .debug("check multiplicity of new node (created at local) "
                                + sub.getId());
                detectMultiplicityViolation(sub.getId(), null, c.getType());
            }
        }
        for (Iterator it = remoteQuery.getDelta().getContent().iterator(); it
                .hasNext();) {
            NodeLevelSubDelta sub = (NodeLevelSubDelta) it.next();
            if (sub instanceof Create) {
                Create c = (Create) sub;
                logger
                        .debug("check multiplicity of new node (created at remote) "
                                + sub.getId());
                detectMultiplicityViolation(sub.getId(), null, c.getType());
            }
        }
    }

    void detectMultiplicityViolation(String id, EObject baseObject, EClass clazz) {
        for (Iterator it = clazz.getEAllReferences().iterator(); it.hasNext();) {
            EReference r = (EReference) it.next();
            if (r.isDerived() || r.isTransient() || !r.isChangeable()
                    || !ConflictDetectionHelper.needMultiplicityCheck(r)) {
                logger.debug("skip " + r.getName());
                continue;
            }
            Conflict conf = ConflictDetectionHelper.checkMultiplicity(id,
                    baseObject, r, localQuery, remoteQuery);
            if (conf != null) {
                conflicts.add(conf);
            }
        }
    } 
}
