/*
 * $RCSfile: DeltaApplication.java,v $
 * $Date: 2006/05/17 12:12:13 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * MergingStub.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/05/17 12:12:13 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;

public class DeltaApplication {

    static Logger logger = Logger.getLogger("DeltaApplication");

    MBXmiResource resource;

    public Set deletedNodes = new HashSet();

    /**
     * the order of the original value of each order property Key: vector of
     * (id,property) , value: list of ID (string) This value is used for
     * applying InsertLink
     */
    Map orderPropertyValue = new Hashtable();

    public DeltaApplication(MBXmiResource model) {
        resource = model;
        for (Iterator it = resource.getAllContents(); it.hasNext();) {
            EObject o = (EObject) it.next();
            for (Iterator it2 = o.eClass().getEAllReferences().iterator(); it2
                    .hasNext();) {
                EReference r = (EReference) it2.next();
                if (r.isOrdered() && r.isMany()) {
                    String id = resource.getURIFragment(o);
                    List l = (List) o.eGet(r);
                    List ids = MergeHelper.getIDList(l);
                    Vector key = new Vector();
                    key.add(id);
                    key.add(r.getName());
                    orderPropertyValue.put(key, ids);
                }
            }
        }
    }

    public void apply(Delta d) {
        for (Iterator it = d.getContent().iterator(); it.hasNext();) {
            NodeLevelSubDelta nl = (NodeLevelSubDelta) it.next();
            if (nl instanceof Create) {
                applyCreate((Create) nl);
            }
            if (nl instanceof Delete) {
                deletedNodes.add(resource.getEObject(nl.getId()));
            }
        }
        for (Iterator it = d.getContent().iterator(); it.hasNext();) {
            NodeLevelSubDelta nl = (NodeLevelSubDelta) it.next();
            applyModify((NodeLevelSubDelta) nl);
        }
        applyDelete();
    }

    public void applyCreate(Create c) {
        EObject o = EcoreUtil.create(c.getType());
        resource.getIdTable().assignId(c.getId(), o);
        resource.getContents().add(o);
    }

    public void applyDelete() {
        for (Iterator it = resource.getAllContents(); it.hasNext();) {
            EObject o = (EObject) it.next();
            for (Iterator it2 = o.eClass().getEAllReferences().iterator(); it2
                    .hasNext();) {
                EReference r = (EReference) it2.next();
                if (r.isMany()) {
                    List l = (List) o.eGet(r);
                    l.removeAll(deletedNodes);
                } else {
                    EObject v = (EObject) o.eGet(r);
                    if (v != null && deletedNodes.contains(v)) {
                        o.eSet(r, null);
                    }
                }
            }
        }
    }

    public void applyModify(NodeLevelSubDelta mod) {
        EObject o = resource.getEObject(mod.getId());
        if (o == null) {
            logger.debug("null object " + mod.getId());
            return;
        }
        for (Iterator it2 = mod.getContent().iterator(); it2.hasNext();) {
            ModifyProp modProp = (ModifyProp) it2.next();
            if (modProp instanceof ModifyPrimitive) {
                applyModifyPrimitive(o, (ModifyPrimitive) modProp);
            } else if (modProp instanceof ModifyLink) {
                ModifyLink ml = (ModifyLink) modProp;
                if (ml.getRemove() != null) {
                    applyRemoveLink(o, (EReference) ml.getProperty(), ml
                            .getRemove());
                }
                for (Iterator it3 = ml.getInsert().iterator(); it3.hasNext();) {
                    InsertLink il = (InsertLink) it3.next();
                    applyInsertLink(o, (EReference) ml.getProperty(), il);
                }
            }
        }
    }

    public void applyModifyPrimitive(EObject o, ModifyPrimitive mp) {
        EAttribute a = (EAttribute) mp.getProperty();
        Object value = MergeHelper.deserializeValue(a, mp.getValue());
        if (mp.getProperty().isMany()) {
            List l = (List) o.eGet(a);
            l.clear();
            l.addAll((List) value);
        } else {
            o.eSet(mp.getProperty(), value);
        }
    }

    public void applyInsertLink(EObject o, EReference r, InsertLink il) {
        if (!r.isMany()) {
            String id = (String) il.getRef().get(0);
            EObject value = resource.getEObject(id);
            o.eSet(r, value);
            return;
        }
        List insertedRefs = MergeHelper.getEObjectList(resource, il.getRef());
        List currentRefList = (List) o.eGet(r);
        if (!r.isOrdered()) {
            currentRefList.addAll(insertedRefs);
            return;
        }
        // remove first before insert.
        currentRefList.removeAll(insertedRefs);
        // if posAfter not specified, then insert to the first possition
        if (il.getPosAfter() == null || il.getPosAfter().equals("")) {
            currentRefList.removeAll(insertedRefs);
            currentRefList.addAll(0, insertedRefs);
        } else {
            // If the node at posAfter has been removed,
            // then get the node before posAfter in the original link value.
            // for example
            // Orifinal value {a b c d } and InsertLink {e f} after c;
            // c has been removed
            // therefore apply InsertLink at posAfter b => {a b e f d}
            String id = resource.getURIFragment(o);
            Vector key = new Vector();
            key.add(id);
            key.add(r.getName());
            List oldIdList = (List) orderPropertyValue.get(key);
            if (oldIdList == null) {
                logger.error("Old property value not found " + id + " "
                        + r.getName());
                return;
            }
            List currentIdList = MergeHelper.getIDList(currentRefList);
            String posAfter = il.getPosAfter();
            int previousIndexOfPosId = oldIdList.indexOf(posAfter) - 1;
            while (!currentIdList.contains(posAfter) && previousIndexOfPosId >= 0) {
                posAfter = (String) oldIdList.get(previousIndexOfPosId);
                previousIndexOfPosId--;
            }
            int insertIndex = currentIdList.indexOf(posAfter) + 1;
            currentRefList.addAll(insertIndex, insertedRefs);
        }
    }

    public void applyRemoveLink(EObject o, EReference r, RemoveLink rl) {
        if (!r.isMany() && r.isUnsettable()) {
            o.eSet(r, null);
        } else {
            List value = MergeHelper.getEObjectList(resource, rl.getRef());
            ((List) o.eGet(r)).removeAll(value);
        }
    }

}
