/*
 * $RCSfile: MergeData.java,v $
 * $Date: 2006/05/17 12:12:13 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * MergeData.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/05/17 12:12:13 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;

public class MergeData extends AdapterImpl {
    private MBXmiResource baseVariant;
    private MBXmiResource localVariant;
    private MBXmiResource remoteVariant;
    private Merge mergeModel;
    
    public MergeData(MBXmiResource base, MBXmiResource local, MBXmiResource remote) {
        this.baseVariant = base;
        this.localVariant = local;
        this.remoteVariant = remote;    
        this.mergeModel = DeltaCalculation.diff3(base, local, remote);
        mergeModel.eAdapters().add(this);        
    }
    
    public MergeData(MBXmiResource base, MBXmiResource local, MBXmiResource remote
            ,Merge mergeModel) {
        this.baseVariant = base;
        this.localVariant = local;
        this.remoteVariant = remote;        
        this.mergeModel = mergeModel;
        mergeModel.eAdapters().add(this);
    }    
    
    /**
     * @return Returns the baseVariant.
     */
    public MBXmiResource getBaseVariant() {
        return baseVariant;
    }

    /**
     * @return Returns the localVariant.
     */
    public MBXmiResource getLocalVariant() {
        return localVariant;
    }

    /**
     * @return Returns the mergeModel.
     */
    public Merge getMergeModel() {
        return mergeModel;
    }

    /**
     * @return Returns the remoteVariant.
     */
    public MBXmiResource getRemoteVariant() {
        return remoteVariant;
    }

    
    public boolean isAdapterForType(Object type) {
        return type == MergeData.class;
    }
}
