/*
 * $RCSfile: MergeHelper.java,v $
 * $Date: 2006/05/16 11:43:11 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * MergeHelper.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/05/16 11:43:11 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MergeHelper {

    static Logger logger = Logger.getLogger("MergeHelper");
    
    static String SEPARATOR = "<SEP>";

    /**
     * 
     * find elements in 'resource' that do not exist in the 'base' resource. The
     * comparison is done with ID
     * 
     * @param base
     * @param resource
     * @return IDs of elements
     * 
     * 
     */
    public static Collection getExtraElements(Resource base, Resource resource) {
        Collection result = new Vector();
        for (Iterator it = resource.getAllContents(); it.hasNext();) {
            EObject o = (EObject) it.next();
            String id = resource.getURIFragment(o);
            EObject o2 = (EObject) base.getEObject(id);
            if (o2 == null) {
                result.add(id);
            }
        }
        return result;
    }

    public static boolean areDiffrent(Object v1, Object v2) {
        if (v1 == null) {
            return v2 != null;
        }
        return !v1.equals(v2);
    }

    public static String serializeValue(EDataType type, Object value) {
        StringBuffer buf = new StringBuffer();
        if (value instanceof Collection) {
            for (Iterator it = ((Collection) value).iterator(); it.hasNext();) {
                Object item = it.next();
                String string = EcoreUtil.convertToString(type, item);
                buf.append(string);
                if (it.hasNext()) {
                    buf.append(SEPARATOR);
                }
            }
        } else if (value != null) {
            return EcoreUtil.convertToString(type, value);
        }
        return null;
    }

    public static Object deserializeValue(EAttribute a, String string) {
        if (string == null) {
            return null;
        }
        EDataType t = a.getEAttributeType();
        if (a.isMany()) {
            Collection c = new Vector();
            int begin = 0;
            int end;
            while ((end = string.indexOf(SEPARATOR, begin)) != -1) {
                String sub = string.substring(begin, end);
                Object item = deserializePrimitive(t, sub);
                c.add(item);
                begin = end + 2;
            }
            String sub = string.substring(begin, string.length());
            Object item = deserializePrimitive(t, sub);
            c.add(item);
            return c;
        } else {
            return deserializePrimitive(t, string);
        }
    }

    public static Object deserializePrimitive(EDataType type, String string) {
        return EcoreUtil.createFromString(type, string);
    }

    public static boolean doesLinkChange(EReference r, Object oldValue,
            Object newValue) {
        if (r.isMany()) {
            Collection oldCol = (Collection) oldValue;
            Collection newCol = (Collection) newValue;
            if (oldCol.size() != newCol.size()) {
                return true;
            }
            Collection ids1 = getIDList(oldCol);
            Collection ids2 = getIDList(newCol);
            if (r.isOrdered()) {
                return !ids1.equals(ids2);
            } else {
                Set s1 = new HashSet(ids1);
                return !s1.equals(ids2);
            }
        }
        if (!equalsByID((EObject) oldValue, (EObject) newValue)) {
            return true;
        }
        return false;
    }

    /**
     * Decide whether the comparion is need. The feature that is derived,
     * transiant, unchangable does not need comparison. <br>
     * If this feature is a link property and has an
     * opposite end. Only one end needs comparison. This method will choose one.
     * 
     * @param f
     * @return
     * 
     */
    public static boolean needsComparison(EStructuralFeature f) {
        if (f.isDerived() || f.isTransient() || !f.isChangeable()) {
            return false;
        }
        if (f instanceof EAttribute) {
            return true;
        }
        return isMainReference( (EReference) f );
    }
    
    
    public static boolean isMainReference(EReference r) {
        EReference op = r.getEOpposite();
        if (op == null) {
            return true;
        }
        // choose based on composition relation ship.
        if (r.isContainment()) {
            return true;
        } else if (r.isContainer()) {
            return false;
        }

        // choose based on orderness
        if (r.isOrdered() && r.isMany()) {
            return true;
        } else if (op.isOrdered() && op.isMany()) {
            return false;
        }

        // choose based on cardinality
        // the "many" feature are chosen over the single-value feature
        if (!r.isMany() && op.isMany()) {
            return false;
        } else if (r.isMany() && !op.isMany()) {
            return true;
        }
        // both have same cardinality
        return chooseLexicographically(r, op);        
    }
    
    

    static boolean chooseLexicographically(EReference r, EReference op) {
        EClass c1 = r.getEContainingClass();
        EClass c2 = op.getEContainingClass();
        String owner1 = r.getContainerClass().getName();
        String owner2 = op.getContainerClass().getName();
        int comp = owner1.compareTo(owner2);
        if (comp < 0)
            return true;
        if (comp > 0)
            return false;
        // two classes have same name
        if (c1 == c2) {
            String uri1 = getURI(c1);
            String uri2 = getURI(c2);
            comp = uri1.compareTo(uri2);
            if (comp < 0)
                return true;
            if (comp > 0)
                return false;
        }
        // two properties belong to the same class
        // compare the property names
        comp = r.getName().compareTo(op.getName());
        if (comp < 0)
            return true;
        if (comp > 0)
            return false;
        // A class can not has two features with the same name.
        return false;
    }

    public static String getURI(EObject o) {
        Resource r = o.eResource();
        if (r == null) {
            return "null";
        }
        return r.getURI().toString() + "#" + r.getURIFragment(o);
    }

    public static boolean equalsByID(EObject o1, EObject o2) {
        if (o1 == null) {
            if (o2 == null)
                return true;
            else
                return false;
        }
        if (o2 == null) {
            return false;
        }
        String id1 = getURIFragment((EObject) o1);
        String id2 = getURIFragment((EObject) o2);
        return id1.equals(id2);
    }

    public static String getURIFragment(EObject o) {
        Resource r = o.eResource();
        if (r == null) {
            return "null";
        }
        return r.getURIFragment(o);
    }

    /**
     * 
     * return the collection of IDs of the objects in the input collection. The
     * input collection is orderred (i.e. is a list), the order will be
     * respected
     * 
     * @return
     */
    public static List getIDList(Collection objects) {
        List ids = new Vector();
        for (Iterator it = objects.iterator(); it.hasNext();) {
            EObject o = (EObject) it.next();
            String id = getURIFragment(o);
            ids.add(id);
        }
        return ids;
    }
    
    
    
    public static List getEObjectList(Resource r, List ids) {
        List result = new Vector();
        for(Iterator it = ids.iterator(); it.hasNext(); ) {
            String id = (String) it.next();
            EObject o = r.getEObject(id);
            if(o!=null) {
                result.add(o);
            } else {
                logger.debug("id not found: " + id +" " +r);
            }
        }
        return result;
    }
    
    
    public static EObject findObjectWithID(List objectList, String id) {
        for(Iterator it= objectList.iterator(); it.hasNext(); ) {
            EObject o = (EObject) it.next();
            if(id.equals(getURIFragment(o))) {  
                return o;
            }
        }
        return null;
    }

    /**
     * 
     * find elements in 'resource' that do exist in the 'base' resource. The
     * comparison is done with ID
     * 
     * @param base
     * @param resource
     * @return IDs of elements
     * 
     * 
     */
    public static Collection getCommonElements(Resource base, Resource resource) {
        Collection result = new Vector();
        for (Iterator it = resource.getAllContents(); it.hasNext();) {
            EObject o = (EObject) it.next();
            String id = resource.getURIFragment(o);
            EObject o2 = (EObject) base.getEObject(id);
            if (o2 != null) {
                result.add(id);
            }
        }
        return result;
    }
    
    

    
 
    

}

