/**
 * <copyright>
 * </copyright>
 *
 * $Id: MergeAdapterFactory.java,v 1.1 2006/05/17 12:12:15 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergePackage
 * @generated
 */
public class MergeAdapterFactory extends AdapterFactoryImpl {
    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static MergePackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public MergeAdapterFactory() {
        if (modelPackage == null) {
            modelPackage = MergePackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    public boolean isFactoryForType(Object object) {
        if (object == modelPackage) {
            return true;
        }
        if (object instanceof EObject) {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch the delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MergeSwitch modelSwitch =
        new MergeSwitch() {
            public Object caseMerge(Merge object) {
                return createMergeAdapter();
            }
            public Object caseConflictSet(ConflictSet object) {
                return createConflictSetAdapter();
            }
            public Object caseConflictResolution(ConflictResolution object) {
                return createConflictResolutionAdapter();
            }
            public Object caseBasicConflictResolution(BasicConflictResolution object) {
                return createBasicConflictResolutionAdapter();
            }
            public Object caseConflict(Conflict object) {
                return createConflictAdapter();
            }
            public Object caseDelta(Delta object) {
                return createDeltaAdapter();
            }
            public Object caseSubDelta(SubDelta object) {
                return createSubDeltaAdapter();
            }
            public Object caseNodeLevelSubDelta(NodeLevelSubDelta object) {
                return createNodeLevelSubDeltaAdapter();
            }
            public Object caseCreate(Create object) {
                return createCreateAdapter();
            }
            public Object caseDelete(Delete object) {
                return createDeleteAdapter();
            }
            public Object caseModifyExisting(ModifyExisting object) {
                return createModifyExistingAdapter();
            }
            public Object caseModifyProp(ModifyProp object) {
                return createModifyPropAdapter();
            }
            public Object caseModifyPrimitive(ModifyPrimitive object) {
                return createModifyPrimitiveAdapter();
            }
            public Object caseModifyLink(ModifyLink object) {
                return createModifyLinkAdapter();
            }
            public Object caseModifyLinkElement(ModifyLinkElement object) {
                return createModifyLinkElementAdapter();
            }
            public Object caseInsertLink(InsertLink object) {
                return createInsertLinkAdapter();
            }
            public Object caseRemoveLink(RemoveLink object) {
                return createRemoveLinkAdapter();
            }
            public Object defaultCase(EObject object) {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    public Adapter createAdapter(Notifier target) {
        return (Adapter)modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge <em>Merge</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge
     * @generated
     */
    public Adapter createMergeAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictSet <em>Conflict Set</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictSet
     * @generated
     */
    public Adapter createConflictSetAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictResolution <em>Conflict Resolution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictResolution
     * @generated
     */
    public Adapter createConflictResolutionAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.BasicConflictResolution <em>Basic Conflict Resolution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.BasicConflictResolution
     * @generated
     */
    public Adapter createBasicConflictResolutionAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict <em>Conflict</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict
     * @generated
     */
    public Adapter createConflictAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta <em>Delta</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta
     * @generated
     */
    public Adapter createDeltaAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta <em>Sub Delta</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta
     * @generated
     */
    public Adapter createSubDeltaAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta <em>Node Level Sub Delta</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta
     * @generated
     */
    public Adapter createNodeLevelSubDeltaAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create <em>Create</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create
     * @generated
     */
    public Adapter createCreateAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete <em>Delete</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete
     * @generated
     */
    public Adapter createDeleteAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyExisting <em>Modify Existing</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyExisting
     * @generated
     */
    public Adapter createModifyExistingAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp <em>Modify Prop</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp
     * @generated
     */
    public Adapter createModifyPropAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive <em>Modify Primitive</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive
     * @generated
     */
    public Adapter createModifyPrimitiveAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink <em>Modify Link</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink
     * @generated
     */
    public Adapter createModifyLinkAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLinkElement <em>Modify Link Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLinkElement
     * @generated
     */
    public Adapter createModifyLinkElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink <em>Insert Link</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink
     * @generated
     */
    public Adapter createInsertLinkAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink <em>Remove Link</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink
     * @generated
     */
    public Adapter createRemoveLinkAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter() {
        return null;
    }

} //MergeAdapterFactory
