/*
 * $RCSfile: IRepository.java,v $
 * $Date: 2006/05/16 11:43:12 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * AbstractRepository.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/05/16 11:43:12 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.repository;


/**
 * This interface defines the functionalities that 
 * a repository should provide for supporting merge
 * 
 * @author P. Sriplakich
 *
 *
 */
public interface IRepository {

    /**
     * 
     * Return the ID that identifies this repository
     * 
     * @return
     * 
     *
     */
    public String getRepositoryID();
        
    /**
     * 
     * Return the lastest update from the repository
     * 
     * 
     * @param filePath
     * @return the data loaded from the remote repository 
     * or null in two cases: 1) the resource is not under version control, 2) is deleted.
     * 
     */
    public RevisionData getLastestDataFromRepository(String filePath) throws RepositoryException;
    
    
    /**
     * 
     * Ontains the base revision data (e.g. for calculating delta)
     * 
     * The implementation should send the cached data without contacting the server.
     * 
     * @return the data or null if the resource is not under version control. 
     * 
     */
    public RevisionData getBaseRevisionData(String filePath);
    
    /**
     * 
     * Returns the revision number of the lastest update in the repository.
     * 
     * @param filePath
     * @param refresh true of the server needs to be recontacted.
     * @return
     * 
     *
     */
    public int getLastestRevisionFromRepository(String filePath, boolean refresh);
    

    
    /**
     * 
     * Compares the revision number of this local cache 
     * and the current revision in the repository.
     * If equal, then the file can be committed without merge.
     * 
     * @param filePath
     * @param refresh true of the server needs to be recontacted.
     * @return
     * 
     */
    public boolean canCommit(String filePath, boolean refresh);
    
    
    
    /**
     * return true if the file is now different from the base revision.
     * The implement uses time stamp to determine the change
     * 
     * @param filePath
     */
    public boolean hasChangedSinceLastCheckout(String filePath);
    
    /**
     * 
     * Commit the file to the repository.
     * The commit is possible only if the base revision of this local cache
     * equals to the last revision from the repository.
     * <br>
     * After commit, both revision numbers will increment by 1.
     * 
     * @param filePath
     * @return whether the commit is done. If it is not done, then merging is needed
     * @throws RepositoryException if the errors occur when contacting the server.
     *
     */
    public boolean commit(String filePath) throws RepositoryException;
    
    /**
     * 
     * Update the content of the local cache with the repository.
     * If merge is needed, then the update is not performed.
     * 
     * @param filePath
     * @return
     * @throws RepositoryException
     * 
     */
    public boolean update(String filePath) throws RepositoryException;
    
    /**
     * 
     * Once the user merge the file,
     * then, he sets the local base revision of this file
     * to the lastest revision from the repository.
     * 
     * @param filePath
     * @param revision
     * @return
     * 
     */
    public int setBaseRevision(String filePath, int revision);
    
    /**
     * 
     * obtain the base revision number of the local cache
     * 
     * @param filePath
     * @return
     */
    public int getBaseRevision(String filePath);
    
    
    
}


