/*
 * $RCSfile: RevisionData.java,v $
 * $Date: 2006/05/16 11:43:12 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * RevisionData.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/05/16 11:43:12 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.repository;

import java.io.IOException;
import java.io.InputStream;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;

/**
 * 
 * This class enable reading a revision 
 * of a resource under version control.  
 * 
 * @author P. Sriplakich
 *
 */
public abstract class RevisionData {
    
    protected String filePath;
    protected int revision;
    
    public RevisionData(String filePath
                , int revision) {
        this.filePath = filePath;
        this.revision = revision;
    }
    
    /**
     * 
     * get the path of the resource under version control.
     * 
     * @return
     */
    public String getFilePath() {
        return filePath;
    }
    /**
     * 
     * 
     * return the Revision number of this value to be read.
     * 
     * @return
     * 
     */
    public int getRevision() {
        return revision;
    }
    /**
     * 
     * return the InputStream for reading 
     * the resouce of this revision
     * 
     * @return
     * 
     */
    public abstract InputStream getInputStream() throws IOException;
    
    
    /**
     * 
     * get the revision data in the form of Resource
     * 
     * @return
     * 
     *
     */
    public Resource getResource() {
        ModelBusResourceSet rs = new ModelBusResourceSet();
        Resource r = rs.createResource(URI.createURI(filePath +"#revison" + revision ));
        InputStream in = null;
        try {
            in = getInputStream();
            r.load(in, null);
        } catch(IOException e) {
            e.printStackTrace();
        }
        try {
            if(in!=null) {
                in.close();
            }
        } catch(IOException e) {
        }
        return r;
    }
        
}


