/*
 * $RCSfile: NotificationEndPoint.java,v $
 * $Date: 2006/03/15 13:46:37 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * NotificationEndPoint.java 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1 $ $Date: 2006/03/15 13:46:37 $

 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.user.notification.Notification;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;

/**
 * Receives notifications from NotificationService and forward them to a
 * specific tool.
 * It implements ModelBus EndPoint in order to share the server infrastructure.
 * 
 * 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * 
 * 
 */
public class NotificationEndPoint implements EndPoint {

    /**
     * The beginning part of the relative path that belongs to this end point.
     */
    public static final String END_POINT_ID = "notification";

    /**
     * Mappings between the URI and the Consumer. The notification messages for
     * each consumer is sent to different URI.
     * 
     */
    Map consumerMap = new Hashtable();

    boolean isServerStarted = false;

    private static Logger logger = Logger.getLogger(NotificationEndPoint.class);

    NotificationEndPoint() {
//        EndPointManagerImpl.getInstance().putEndPoint(END_POINT_ID, this);
    }

    /**
     * Binds the consumer to the web server. So, The consumer can receive
     * notifications via this server.
     * 
     * @param con
     * @return the URL for connecting to this consumer.
     * @throws Exception
     * @throws NotifServiceNotAvailableException
     * @throws Exception
     * 
     */
    public String bindConsumerToServer(int port, NotificationConsumer con)
            throws Exception {

        if (consumerMap.containsValue(con)) {
            Iterator it = consumerMap.keySet().iterator();
            while (it.hasNext()) {
                String relativePath = (String) it.next();
                if (consumerMap.get(relativePath) == con) {
                    return relativePath;
                }
            }
        }
        // start a server if not already started
        AbstractServer s = ServerManager.getInstance().getServer(port);
        // bind EndPoint that manages all incomming requests
        EndPointManagerImpl.getInstance().putEndPoint(END_POINT_ID, this);
        
        
        String relativePath = createRelativePath(con);
        consumerMap.put(relativePath, con);
        String url = "http://" + ServerManager.getHost() + ":" + port + "/"
                + s.getContext() + "/" + relativePath;

        return url;

    }

    /**
     * Creates a unique URI for this consumer. For example /mytool.MyConsumer.
     * 
     * @param con
     * @return the relativePath
     * 
     */
    String createRelativePath(NotificationConsumer con) {
        String base = END_POINT_ID + "/" + con.getClass().getName();
        int i = 0;
        while (consumerMap.containsKey(base + i)) {
            i++;
        }
        String uri = base + i;
        return uri;
    }

    /**
     * Unbind the consumer from the web server. The consumer can no longer receive
     * notifications.
     * 
     * @param con
     * 
     */
    public void unbindConsumerFromServer(NotificationConsumer con) {
        consumerMap.values().remove(con);
        //if no more consumers remove end point
        if (consumerMap.values().isEmpty()) EndPointManagerImpl.getInstance().removeEndPoint(END_POINT_ID);
       
    }

    public NotificationConsumer getConsumer(String uri) {
        return (NotificationConsumer) consumerMap.get(uri);
    }

    public void execute(String urlpath, SOAPEnvelope req, SOAPEnvelope resp)
            throws SOAPException {
        // String
        // serviceName=AxisEngine.getCurrentMessageContext().getTargetService();
        // String uri="/axis/services/"+serviceName;
        NotificationConsumer con = this.getConsumer(urlpath);
        if (con == null) {
            logger
                    .info("Adapter: received notification for unknown consumer. uri="
                            + urlpath);
            return;
        }
        SerializedNotification[] rawNotifs = NotificationServiceUtil
                .extractNotifications(req.getBody());
        for (int i = 0; i < rawNotifs.length; i++) {
            Notification notif = new Notification(rawNotifs[i]);
            con.consume(notif);
        }
    }

}
