/*
 * $RCSfile: ModelSerializer.java,v $
 * $Date: 2006/05/16 11:43:11 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * Serializer.java defines signatures for prameter serialisation methods
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1 $ $Date: 2006/05/16 11:43:11 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

/*
 * Serializer
 * 
 */

public interface ModelSerializer {
    
    /**
     * serialize defines procedure for serialisation of parameters 
     * 
     * @param params list of parameter definitions. 
     * Parameter in the list may or may not have ModelType. 
     * The implementation can skip parameter that do not have ModelType
     * 
     * @param value list of parameter values.
     * The list order corresponds the order of the parameter definition list.
     * Each item in the list may represent a single value argument or multi-value argument,
     * depending on the parameter multiplicity.
     * 
     * @return a set of serialized Xmi document
     *
     */
    public SerializedXmiDocument[] serialize(Parameter[] params, Object[] values);
    

    /**
     * deserialize the set of XMI documents.
     * 
     * @param documents
     * @return
     * 
     *
     */
    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents);
    
    /**
     * 
     * Obtain references to the elements in the XMI documents.
     * 
     * @param documents the documents that have been previously serialized.
     * @param p the parameter definition.
     * 
     * @param o the parameter value. 
     * If the parameter is multi-valued, o represents an item of the multi-valued parameter.
     * 
     * @return
     * 
     *
     */
    public ModelElementReference[] getReferences(SerializedXmiDocument[] documents, 
            Parameter p, Object o);
    
    
    /**
     * 
     * Obtain the model element object referenced by the specified references
     * 
     * @param data contains all model elements that have been serialized.
     * @param p the parameter definition.
     * @param refs a set of references
     * 
     * @return the object representing model elements that are referenced
     * 
     *
     */
    public Object dereference(DeserializedModel[] data, Parameter p, ModelElementReference[] refs);







}
