/*
 * $RCSfile: Emf2XmiConversion.java,v $
 * $Date: 2006/06/20 15:49:01 $
 * $Revision: 1.8 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */


package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;


import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;

/**
 * Emf2XmiConversion This class is able to convert a collection of EObjects to a String. This
 * string contains the model in XMI2.0 format.
 * 
 * @author Prawee Sriplakich (LIP6)
 * 
 * @version $Revision: 1.8 $ $Date: 2006/06/20 15:49:01 $
 */
public class Emf2XmiConversion {


    static {
        ModelBusResourceSet.init();
    }

    /**
     * Serializes the elements in the collection to a String. The elements that
     * are in the same "Resources" as the elements in the collection will be
     * also serialized. <br>
     * 
     * @param emfobjs
     * @return
     * @throws IOException
     * 
     * 
     */
    public static String convertToString(Collection emfobjs) throws IOException {
        Resource[] resources = ModelUtil.getResourcesFromObjects(emfobjs, true, 
                GlobalResourceRegistry.GLOBAL_URI_PREFIX_SET);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for(int i=0; i<resources.length; i++) {
            resources[i].save(bout, null);
        }
        return bout.toString();
    }




}
