/*
 * $RCSfile: IdTableRegistry.java,v $
 * $Date: 2006/05/16 11:43:11 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * IdTableRegistry.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/05/16 11:43:11 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi;

import java.util.Map;
import java.util.WeakHashMap;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class IdTableRegistry {

    /**
     * This table stores Id of the elements with no resource.
     */
    static IdTable defaultTable = new IdTable();
    
    static Map tableMap = new WeakHashMap();
    
    public static IdTable getIdTable(Resource r) {
        if(tableMap.containsKey(r)) {
            return (IdTable) tableMap.get(r);
        }
        IdTable t = new IdTable();
        tableMap.put(r, t);
        return t;
    }
    
    
    
    public static IdTable getIdTable(EObject o) {
        Resource r = o.eResource();
        if(r == null) {
            return defaultTable;
        }
        IdTable t = getIdTable(r);
        return t;        
    }
    
    /**
     * 
     * get the ID of the object 
     * with the ID table in this registry
     * 
     * @param o
     * @return
     * 
     *
     */
    public static String getId(EObject o) {
        IdTable t = getIdTable(o);
        return t.getId(o);
    }
    
    

    
 
    
    
}
